<?php

// +----------------------------------------------------------------------
// | JiZhiCMS { 极致CMS，给您极致的建站体验 }  
// +----------------------------------------------------------------------
// | Copyright (c) 2018-2099 http://www.jizhicms.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 留恋风 <2581047041@qq.com>
// +----------------------------------------------------------------------
// | Date：2022/02/03
// +----------------------------------------------------------------------


namespace Home\plugins;

use Home\c\CommonController;
class WebApiController extends CommonController
{
    function _init(){
        parent::_init();
        header('Access-Control-Allow-Origin:*');

    }

    function index(){
        $pw = $this->frparam('pw',1);

        //检测是否开启插件
        //检测是否关闭插件或者卸载插件
        $w['filepath'] = 'webapi';
        $w['isopen'] = 1;
        $res = M('plugins')->find($w);
        if($res){
            $config = json_decode($res['config'],1);
            if(!$config && $pw!=$config['password']){
                echo '登录密码错误';exit;
            }
            $tid = $this->frparam('tid');
            if(!$tid){
                echo '栏目不能为空';
                exit;
            }
            $type = $this->classtypedata[$tid];
            switch($type['molds']){
                case 'article':
                    $data = $this->frparam();

                    if(M('article')->find(['title'=>$this->frparam('title',1)])){
                        echo 0;exit;
                    }

                    $data['seo_title'] = ($this->frparam('seo_title',1,'')=='')?$this->frparam('title',1,''):$this->frparam('seo_title',1,'');
                    if($data['addtime']){
                        $data['addtime'] = strtotime($data['addtime']);//格式化时间
                    }else{
                        $data['addtime'] = time();
                    }
                    if($data['tags']){
                        $data['tags'] = ','.$data['tags'].',';
                    }

                    $data['body'] = $this->frparam('body',4);
                    $data['body'] = remote_data_local($data['body'],$data['tid'],'article');
                    $data['userid'] = $this->frparam('userid',1,'1');
                    $data['description'] = ($this->frparam('description',1,'')=='') ? newstr(strip_tags($data['body']),200) : $this->frparam('description',1);
                    if($this->frparam('litpic',1,'')==''){
                        $pattern='/<img.+src=\"?(.+\.(jpg|gif|bmp|bnp|PNG))\"?.+>/i';
                        if($this->frparam('body',1,'')!=''){
                            preg_match_all($pattern,stripslashes($data['body']),$matchContent);

                            if(isset($matchContent[1][0])){
                                $data['litpic'] = $matchContent[1][0];
                            }else{
                                $data['litpic'] = '';
                            }
                        }else{
                            $data['litpic'] = '';
                        }

                    }else if($data['litpic']){
                        $data['litpic'] = stripos($data['litpic'],'http')!==false ? $this->localimg($data['litpic'],$data['tid'],'article') : $data['litpic'];
                    }

                    $pclass = $type;
                    $data['molds'] = $pclass['molds'];
                    $data['htmlurl'] = $pclass['htmlurl'];

                    $r = M('Article')->add($data);
                    if($r){

                        //tags处理
                        if($data['tags']){
                            $tags = explode(',',$data['tags']);
                            foreach($tags as $v){
                                if($v!=''){
                                    $rr = M('tags')->find(['keywords'=>$v]);
                                    if(!$rr){
                                        $w['keywords'] = $v;
                                        $w['newname'] = '';
                                        $w['url'] = '';
                                        $w['num'] = -1;
                                        $w['isshow'] = 1;
                                        $w['number'] = 1;
                                        $w['target'] = '_blank';
                                        M('tags')->add($w);
                                    }else{
                                        M('tags')->goInc(['keywords'=>$v],'number',1);
                                    }
                                }
                            }
                        }


                        if($data['ownurl']){
                            if(!M('customurl')->find(['url'=>$data['ownurl']])){
                                M('customurl')->add(['molds'=>'article','url'=>$data['ownurl'],'tid'=>$data['tid'],'addtime'=>time(),'aid'=>$r]);
                            }
                        }



                        echo 0;
                    }else{
                        echo '录入数据库失败';
                    }


                    break;

                case 'product':
                    $data = $this->frparam();
                    if(M('product')->find(['title'=>$this->frparam('title',1)])){
                        echo 0;exit;
                    }

                    $data['seo_title'] = ($this->frparam('seo_title',1,'')=='')?$this->frparam('title',1,''):$this->frparam('seo_title',1,'');
                    if($data['addtime']){
                        $data['addtime'] = strtotime($data['addtime']);//格式化时间
                    }else{
                        $data['addtime'] = time();
                    }
                    $data['body'] = $this->frparam('body',4,'');
                    $data['body'] = remote_data_local($data['body'],$data['tid'],'product');
                    $data['price'] = $this->frparam('price',3,'0');
                    $data['userid'] = $this->frparam('userid',1,'1');
                    $data['description'] = ($this->frparam('description',1,'')=='') ? newstr(strip_tags($data['body']),200) : $this->frparam('description',1);
                    if($this->frparam('litpic',1,'')==''){
                        $pattern='/<img.+src=\"?(.+\.(jpg|gif|bmp|bnp|PNG))\"?.+>/i';
                        if($this->frparam('body',1)!=''){
                            preg_match_all($pattern,stripslashes($data['body']),$matchContent);

                            if(isset($matchContent[1][0])){
                                $data['litpic'] = $matchContent[1][0];
                            }else{
                                $data['litpic'] = '';
                            }
                        }else{
                            $data['litpic'] = '';
                        }

                    }else if($data['litpic']){
                        $data['litpic'] = stripos($data['litpic'],'http')!==false ? $this->localimg($data['litpic'],$data['tid'],'product') : $data['litpic'];
                    }

                    if($data['tags']){
                        $data['tags'] = ','.$data['tags'].',';
                    }

                    $pclass = $type;
                    $data['molds'] = $pclass['molds'];
                    $data['htmlurl'] = $pclass['htmlurl'];
                    $r = M('product')->add($data);
                    if($r){
                        //tags处理
                        if($data['tags']){
                            $tags = explode(',',$data['tags']);
                            foreach($tags as $v){
                                if($v!=''){
                                    $rr = M('tags')->find(['keywords'=>$v]);
                                    if(!$rr){
                                        $w['keywords'] = $v;
                                        $w['newname'] = '';
                                        $w['url'] = '';
                                        $w['num'] = -1;
                                        $w['isshow'] = 1;
                                        $w['number'] = 1;
                                        $w['tids'] = $data['tid'] ? ','.$data['tid'].',' : '';
                                        $w['target'] = '_blank';
                                        M('tags')->add($w);
                                    }else{
                                        $tags_tids = $rr['tids'] ? $rr['tids'].$data['tid'].',' : ','.$data['tid'].',';
                                        $ww['tids'] = $tags_tids;
                                        $ww['number'] = $rr['number']+1;
                                        M('tags')->update(['keywords'=>$v],$ww);
                                    }
                                }
                            }
                        }
                        if($data['ownurl']){
                            if(!M('customurl')->find(['url'=>$data['ownurl']])){
                                M('customurl')->add(['molds'=>'product','url'=>$data['ownurl'],'tid'=>$data['tid'],'addtime'=>time(),'aid'=>$r]);
                            }
                        }

                        echo 0;
                    }else{
                        echo '录入数据库失败';
                    }

                    break;

                case 'classtype':

                    $htmlurl = $this->frparam('htmlurl',1);
                    $first = $this->frparam('first',0,1);
                    if($htmlurl==''){
                        if($first){
                            $htmlurl = str_replace(' ','',pinyin($this->frparam('classname',1),'first'));
                        }else{
                            $htmlurl = str_replace(' ','',pinyin($this->frparam('classname',1)));
                        }

                    }
                    $w['pid'] = $this->frparam('pid',0,0);
                    $w['orders'] = $this->frparam('orders',0,0);
                    $w['classname'] = $this->frparam('classname',1,'');
                    $w['molds'] = $this->frparam('molds',1,'');
                    $w['description'] = $this->frparam('description',1,'');
                    $w['keywords'] = $this->frparam('keywords',1,'');
                    $w['litpic'] = $this->frparam('litpic',1,'');
                    $w['body'] = $this->frparam('body',4,'');
                    $w['body'] = remote_data_local($w['body'],0,'classtype');
                    $w['htmlurl'] = $htmlurl;
                    $w['iscover'] = $this->frparam('iscover',0,0);
                    $w['lists_html'] = $this->frparam('lists_html',1,'');
                    $w['details_html'] = $this->frparam('details_html',1,'');
                    $w['lists_num'] = $this->frparam('lists_num',0,10);
                    if($w['lists_html']=='' && $w['details_html']==''){
                        $parent = M('classtype')->find(array('id'=>$w['pid']));
                        if($parent['iscover']==1){
                            $w['lists_html']=$parent['lists_html'];
                            $w['details_html']=$parent['details_html'];
                            $w['lists_num']=$parent['lists_num'];
                        }
                    }


                    $data = $this->frparam();
                    $w = array_merge($data,$w);
                    $a = M('classtype')->add($w);
                    if($a){
                        setCache('classtypetree',null);
                        echo 0;
                    }else{
                        echo '录入数据库失败';
                    }

                    break;


                default:
                    $data = $this->frparam();
                    $molds = $type['molds'];
                    $pclass = $type;
                    $data['htmlurl'] = $pclass['htmlurl'];
                    $data['tid'] = $this->frparam('tid',0,0);

                    if($data['tags']){
                        $data['tags'] = ','.$data['tags'].',';
                    }

                    if($data['addtime']){
                        $data['addtime'] = strtotime($data['addtime']);//格式化时间
                    }else{
                        $data['addtime'] = time();
                    }
                    $data['body'] = remote_data_local($data['body'],$data['tid']??0,$molds);

                    $r = M($molds)->add($data);
                    if($r){

                        //tags处理
                        if($data['tags']){
                            $tags = explode(',',$data['tags']);
                            foreach($tags as $v){
                                if($v!=''){
                                    $rr = M('tags')->find(['keywords'=>$v]);
                                    if(!$rr){
                                        $w['keywords'] = $v;
                                        $w['newname'] = '';
                                        $w['url'] = '';
                                        $w['num'] = -1;
                                        $w['isshow'] = 1;
                                        $w['number'] = 1;
                                        $w['tids'] = $data['tid'] ? ','.$data['tid'].',' : '';
                                        $w['target'] = '_blank';
                                        M('tags')->add($w);
                                    }else{
                                        $tags_tids = $rr['tids'] ? $rr['tids'].$data['tid'].',' : ','.$data['tid'].',';
                                        $ww['tids'] = $tags_tids;
                                        $ww['number'] = $rr['number']+1;
                                        M('tags')->update(['keywords'=>$v],$ww);
                                    }
                                }
                            }
                        }

                        if($data['ownurl']){
                            if(!M('customurl')->find(['url'=>$data['ownurl']])){
                                M('customurl')->add(['molds'=>$molds,'url'=>$data['ownurl'],'tid'=>$data['tid'],'addtime'=>time(),'aid'=>$r]);
                            }
                        }
                        echo 0;
                    }else{
                        echo '录入数据库失败';
                    }



                    break;

            }



        }else{
            echo '插件未开启';
        }






    }

    function getClass(){
        $pw = $this->frparam('pw',1);
        $w['filepath'] = 'webapi';
        $w['isopen'] = 1;
        $res = M('plugins')->find($w);
        if($res){
            $config = json_decode($res['config'],1);
            if(!$config && $pw!=$config['password']){
                echo '登录密码错误';exit;
            }
            $lists = M('classtype')->findAll();
            foreach($lists as $v){

                echo '<option value="'.$v['id'].'">'.$v['classname'].'</option>';
            }
        }else{
            echo '插件未开启';
        }


    }

    function localimg($value,$tid=0,$molds=''){
        $webconfig = webConf();
        $web_basehost    = get_domain();
        if(isset($webconfig['admin_save_path'])){
            //替换日期事件
            $t = time();
            $d = explode('-', date("Y-y-m-d-H-i-s"));
            $format = $webconfig['admin_save_path'];
            $format = str_replace("{yyyy}", $d[0], $format);
            $format = str_replace("{yy}", $d[1], $format);
            $format = str_replace("{mm}", $d[2], $format);
            $format = str_replace("{dd}", $d[3], $format);
            $format = str_replace("{hh}", $d[4], $format);
            $format = str_replace("{ii}", $d[5], $format);
            $format = str_replace("{ss}", $d[6], $format);
            $format = str_replace("{time}", $t, $format);
            if($format!=''){
                //检查文件是否存在
                if(strpos($format,'/')!==false && !file_exists(APP_PATH.$format)){
                    $path = explode('/',$format);
                    $path1 = APP_PATH;
                    foreach($path as $v){
                        if($path1==APP_PATH){
                            if(!file_exists($path1.$v)){
                                mkdir($path1.$v,0777);
                            }
                            $path1.=$v;
                        }else{
                            if(!file_exists($path1.'/'.$v)){
                                mkdir($path1.'/'.$v,0777);
                            }
                            $path1.='/'.$v;
                        }
                    }
                }else if(!file_exists(APP_PATH.$format)){
                    mkdir(APP_PATH.$format,0777);
                }
                $admin_save_path = $format;

            }else{
                $admin_save_path = 'public/Admin';
            }


        }else{
            $admin_save_path = 'public/Admin';
        }
        $dirname =  $admin_save_path.'/';
        $imgUrl = trim($value);
        //  $imgUrl = preg_replace('/\\\"/', '', $imgUrl); //img 被转义的数据
        $imgUrl = preg_replace('/#/', '', $imgUrl);

        // 本站图片 / 根网址图片 / 第三方存储插件的图片
        if (preg_match("/\/\/('.$web_basehost.')\//i", $imgUrl)) {
            return $value;
        }
        // 不是合法链接
        if (!preg_match("#^http(s?):\/\/#i", $imgUrl)) {
            return $value;
        }

        $heads = @get_headers($imgUrl, 1);

        // 获取请求头并检测死链
        if (empty($heads)) {
            return $value;
        } else if (!(stristr($heads[0], "200") && !stristr($heads[0], "304"))) {
            return $value;
        }
        // 图片扩展名
        $fileType = substr($heads['Content-Type'], -4, 4);
        if (!preg_match("#\.(jpg|jpeg|gif|png|ico|bmp|webp|svg)#i", $fileType)) {
            if ($fileType == 'image/gif') {
                $pix = "gif";
            } else if ($fileType == 'image/png') {
                $pix = "png";
            } else if ($fileType == 'image/x-icon') {
                $pix = "ico";
            } else if ($fileType == 'image/bmp') {
                $pix = "bmp";
            }  else if ($fileType == 'image/webp') {
                $pix = "webp";
            } else if ($heads['Content-Type'] == 'image/svg+xml') {
                $pix = "svg";
            } else {
                $pix = 'jpg';
            }
        }
        $pix = strtolower($pix);

        //打开输出缓冲区并获取远程图片
        ob_start();
        $context = stream_context_create(
            array('http' => array(
                'follow_location' => false // don't follow redirects
            ))
        );
        readfile($imgUrl, false, $context);
        $img = ob_get_contents();
        ob_end_clean();
        preg_match("/[\/]([^\/]*)[\.]?[^\.\/]*$/", $imgUrl, $m);

        $file             = [];
        $file['oriName']  = $m ? $m[1] : "";
        $file['filesize'] = strlen($img);
        $file['ext']      = $pix;
        $file['name']     = date("ymdHis") . mt_rand(100, 999) .'.'. $file['ext'];
        $file['fullName'] = $dirname . $file['name'];
        $fullName         = $file['fullName'];

        //检查文件大小是否超出限制
        if ($file['filesize'] >= 20480000) {
            return $value;
        }

        //移动文件
        if (!(file_put_contents($fullName, $img) && file_exists($fullName))) { //移动失败
            return $value;
        }
        //处理水印
        if( (strtolower($pix)=='png' || strtolower($pix)=='jpg' || strtolower($pix)=='jpeg') && $webconfig['iswatermark']==1 ){
            watermark($file['fullName'],APP_PATH.$webconfig['watermark_file'],$webconfig['watermark_t'],$webconfig['watermark_tm'],$webconfig['text_word']);
        }


        $fileurl = '/'.$file['fullName'];
        $filesize = round(filesize(APP_PATH.$file['fullName'])/1024,2);
        M('pictures')->add(['litpic'=>'/'.$file['fullName'],'addtime'=>time(),'userid'=>$_SESSION['admin']['id'],'size'=>$filesize,'filetype'=>strtolower($pix),'tid'=>$tid,'molds'=>$molds]);
        return $fileurl;

    }



}