<?php

// +----------------------------------------------------------------------
// | JiZhiCMS { 极致CMS，给您极致的建站体验 }  
// +----------------------------------------------------------------------
// | Copyright (c) 2018-2099 http://www.jizhicms.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 留恋风 <2581047041@qq.com>
// +----------------------------------------------------------------------
// | Date：2022/02/03
// +----------------------------------------------------------------------


namespace app\home\plugins;

use app\home\c\CommonController;
class SkycaijiController extends CommonController
{

    function _init(){
        parent::_init();
        header('Access-Control-Allow-Origin:*');

    }
//http://www.demo.mm/Skycaiji/index?pw=123456
    function index(){
        $pw = $this->frparam('pw',1);

        $w['filepath'] = 'skycaiji';
        $w['isopen'] = 1;
        $res = M('plugins')->find($w);
        if($res){
            $config = json_decode($res['config'],1);
            if($pw!=$config['password']){

                JsonReturn(['id'=>0,'target'=>'','desc'=>'','error'=>'登录密码错误']);
            }
            $tid = $this->frparam('tid');
            if(!$tid){
                JsonReturn(['id'=>0,'target'=>'','desc'=>'','error'=>'栏目不能为空']);

            }

            $type = $this->classtypedata[$tid];
            switch($type['molds']){
                case 'article':

                    $data = $this->frparam();

                    $data['seo_title'] = ($this->frparam('seo_title',1,'')=='')?$this->frparam('title',1,''):$this->frparam('seo_title',1,'');
                    if($data['addtime']){
                        $data['addtime'] = strtotime($data['addtime']);//格式化时间
                    }else{
                        $data['addtime'] = time();
                    }
                    if($data['tags']){
                        $data['tags'] = ','.$data['tags'].',';
                    }
                    $data['body'] = $this->frparam('body',4);
                    $data['body'] = remote_data_local($data['body'],$data['tid'],'article');
                    $data['userid'] = $this->frparam('userid',1,'1');
                    $data['description'] = ($this->frparam('description',1,'')=='') ? newstr(strip_tags($data['body']),200) : $this->frparam('description',1);
                    if($this->frparam('litpic',1,'')==''){
                        $pattern='/<img.+src=\"?(.+\.(jpg|gif|bmp|bnp|PNG))\"?.+>/i';
                        if($this->frparam('body',1,'')!=''){
                            preg_match_all($pattern,stripslashes($data['body']),$matchContent);

                            if(isset($matchContent[1][0])){
                                $data['litpic'] = $matchContent[1][0];
                            }else{
                                $data['litpic'] = '';
                            }
                        }else{
                            $data['litpic'] = '';
                        }

                    }else if($data['litpic']){
                        $data['litpic'] = stripos($data['litpic'],'http')!==false ? $this->localimg($data['litpic'],$data['tid'],'article') : $data['litpic'];
                    }

                    $pclass = $type;
                    $data['molds'] = $pclass['molds'];
                    $data['htmlurl'] = $pclass['htmlurl'];

                    //检测是否开启伪原创
                    if($config['iswyc']==1){
                        $data['title'] = $this->fy($data['title']);
                        $data['seo_title'] = $this->fy($data['seo_title']);
                        if(isset($data['keywords'])){
                            $data['keywords'] = $this->fy($data['keywords']);
                        }
                        $data['body'] = $this->fy($data['body']);

                    }


                    $r = M('Article')->add($data);
                    if($r){
                        if($data['ownurl'] && !M('customurl')->find(['url'=>$data['ownurl']])){
                            M('customurl')->add(['molds'=>'article','url'=>$data['ownurl'],'tid'=>$data['tid'],'addtime'=>time(),'aid'=>$r]);
                        }
                        //tags处理
                        if($data['tags']){
                            $tags = explode(',',$data['tags']);
                            foreach($tags as $v){
                                if($v!=''){
                                    $rr = M('tags')->find(['keywords'=>$v]);
                                    if(!$rr){
                                        $w['keywords'] = $v;
                                        $w['newname'] = '';
                                        $w['url'] = '';
                                        $w['num'] = -1;
                                        $w['isshow'] = 1;
                                        $w['number'] = 1;
                                        $w['target'] = '_blank';
                                        M('tags')->add($w);
                                    }else{
                                        M('tags')->goInc(['keywords'=>$v],'number',1);
                                    }
                                }
                            }
                        }
                        JsonReturn(['id'=>$r,'target'=>gourl($r,$data['htmlurl']),'desc'=>'标题：'.$data['title'],'error'=>'测试成功！']);

                    }else{
                        JsonReturn(['id'=>0,'target'=>'','desc'=>'','error'=>'测试失败！']);
                    }


                    break;

                case 'product':
                    $data = $this->frparam();
                    $data['seo_title'] = ($this->frparam('seo_title',1,'')=='')?$this->frparam('title',1,''):$this->frparam('seo_title',1,'');
                    if($data['addtime']){
                        $data['addtime'] = strtotime($data['addtime']);//格式化时间
                    }else{
                        $data['addtime'] = time();
                    }
                    if($data['tags']){
                        $data['tags'] = ','.$data['tags'].',';
                    }
                    $data['body'] = $this->frparam('body',4,'');
                    $data['body'] = remote_data_local($data['body'],$data['tid'],'product');
                    $data['price'] = $this->frparam('price',3,'0');
                    $data['userid'] = $this->frparam('userid',1,'1');
                    $data['description'] = ($this->frparam('description',1,'')=='') ? newstr(strip_tags($data['body']),200) : $this->frparam('description',1);
                    if($this->frparam('litpic',1,'')==''){
                        $pattern='/<img.+src=\"?(.+\.(jpg|gif|bmp|bnp|PNG))\"?.+>/i';
                        if($this->frparam('body',1)!=''){
                            preg_match_all($pattern,stripslashes($data['body']),$matchContent);

                            if(isset($matchContent[1][0])){
                                $data['litpic'] = $matchContent[1][0];
                            }else{
                                $data['litpic'] = '';
                            }
                        }else{
                            $data['litpic'] = '';
                        }

                    }else if($data['litpic']){
                        $data['litpic'] = stripos($data['litpic'],'http')!==false ? $this->localimg($data['litpic'],$data['tid'],'product') : $data['litpic'];
                    }


                    $pclass = $type;
                    $data['molds'] = $pclass['molds'];
                    $data['htmlurl'] = $pclass['htmlurl'];
                    $r = M('product')->add($data);
                    if($r){
                        if($data['ownurl'] && !M('customurl')->find(['url'=>$data['ownurl']])){
                            M('customurl')->add(['molds'=>'product','url'=>$data['ownurl'],'tid'=>$data['tid'],'addtime'=>time(),'aid'=>$r]);
                        }
                        //tags处理
                        if($data['tags']){
                            $tags = explode(',',$data['tags']);
                            foreach($tags as $v){
                                if($v!=''){
                                    $rr = M('tags')->find(['keywords'=>$v]);
                                    if(!$rr){
                                        $w['keywords'] = $v;
                                        $w['newname'] = '';
                                        $w['url'] = '';
                                        $w['num'] = -1;
                                        $w['isshow'] = 1;
                                        $w['number'] = 1;
                                        $w['target'] = '_blank';
                                        M('tags')->add($w);
                                    }else{
                                        M('tags')->goInc(['keywords'=>$v],'number',1);
                                    }
                                }
                            }
                        }
                        JsonReturn(['id'=>$r,'target'=>gourl($r,$data['htmlurl']),'desc'=>'标题：'.$data['title'],'error'=>'测试成功！']);

                    }else{
                        JsonReturn(['id'=>0,'target'=>'','desc'=>'','error'=>'测试失败！']);
                    }

                    break;

                case 'classtype':

                    $htmlurl = $this->frparam('htmlurl',1);
                    $first = $this->frparam('first',0,1);
                    if($htmlurl){
                        if($first){
                            $htmlurl = str_replace(' ','',pinyin($this->frparam('classname',1),'first'));
                        }else{
                            $htmlurl = str_replace(' ','',pinyin($this->frparam('classname',1)));
                        }

                    }
                    $w = $this->frparam();
                    $w['pid'] = $this->frparam('pid',0,0);
                    $w['orders'] = $this->frparam('orders',0,0);
                    $w['classname'] = $this->frparam('classname',1,'');
                    $w['molds'] = $this->frparam('molds',1,'');
                    $w['description'] = $this->frparam('description',1,'');
                    $w['keywords'] = $this->frparam('keywords',1,'');
                    $w['litpic'] = $this->frparam('litpic',1,'');
                    $w['body'] = $this->frparam('body',4,'');
                    $w['body'] = remote_data_local($w['body'],0,'classtype');
                    $w['htmlurl'] = $htmlurl;
                    $w['iscover'] = $this->frparam('iscover',0,0);
                    $w['lists_html'] = $this->frparam('lists_html',1,'');
                    $w['details_html'] = $this->frparam('details_html',1,'');
                    $w['lists_num'] = $this->frparam('lists_num',0,10);
                    if($w['lists_html']=='' && $w['details_html']==''){
                        $parent = M('classtype')->find(array('id'=>$w['pid']));
                        if($parent['iscover']==1){
                            $w['lists_html']=$parent['lists_html'];
                            $w['details_html']=$parent['details_html'];
                            $w['lists_num']=$parent['lists_num'];
                        }
                    }


                    $r = M('classtype')->add($w);
                    if($r){

                        $htmlpath = webConf('mobile_html');
                        $htmlpath = ($htmlpath=='' || $htmlpath=='/') ? '' : '/'.$htmlpath;
                        $file_txt = File_TXT_HIDE ? '' : '.html';
                        if($file_txt==''){
                            $file_txt = CLASS_HIDE_SLASH ? $file_txt : $file_txt.'/';
                        }
                        $url = get_domain().$htmlpath.'/'.$w['htmlurl'].$file_txt;
                        setCache('classtypetree',null);
                        JsonReturn(['id'=>$r,'target'=>$url,'desc'=>'栏目名：'.$w['classname'],'error'=>'测试成功！']);

                    }else{
                        JsonReturn(['id'=>0,'target'=>'','desc'=>'','error'=>'发布失败！']);
                    }

                    break;


                default:
                    $data = $this->frparam();
                    $molds = $type['molds'];
                    if($data['addtime']){
                        $data['addtime'] = strtotime($data['addtime']);//格式化时间
                    }else{
                        $data['addtime'] = time();
                    }
                    if($data['tags']){
                        $data['tags'] = ','.$data['tags'].',';
                    }
                    $pclass = $type;
                    $data['htmlurl'] = $pclass['htmlurl'];
                    $data['body'] = remote_data_local($data['body'],$data['tid']??0,$molds);

                    $r = M($molds)->add($data);

                    if($r){
                        if($data['ownurl'] && !M('customurl')->find(['url'=>$data['ownurl']])){
                            M('customurl')->add(['molds'=>$molds,'url'=>$data['ownurl'],'tid'=>$data['tid'],'addtime'=>time(),'aid'=>$r]);
                        }
                        //tags处理
                        if($data['tags']){
                            $tags = explode(',',$data['tags']);
                            foreach($tags as $v){
                                if($v!=''){
                                    $rr = M('tags')->find(['keywords'=>$v]);
                                    if(!$rr){
                                        $w['keywords'] = $v;
                                        $w['newname'] = '';
                                        $w['url'] = '';
                                        $w['num'] = -1;
                                        $w['isshow'] = 1;
                                        $w['number'] = 1;
                                        $w['target'] = '_blank';
                                        M('tags')->add($w);
                                    }else{
                                        M('tags')->goInc(['keywords'=>$v],'number',1);
                                    }
                                }
                            }
                        }
                        JsonReturn(['id'=>$r,'target'=>get_domain().'/'.$data['htmlurl'].'/'.$r,'desc'=>'','error'=>'发布成功！']);

                    }else{
                        JsonReturn(['id'=>0,'target'=>'','desc'=>'','error'=>'发布失败！']);
                    }



                    break;

            }



        }else{
            JsonReturn(['id'=>0,'target'=>'','desc'=>'','error'=>'插件未开启']);
        }






    }

    function translate($text,$from,$to){
        //$url = "http://translate.google.cn/translate_a/single?client=gtx&dt=t&ie=UTF-8&oe=UTF-8&sl=$from&tl=$to&q=". urlencode($text);
        $url = "http://api.2wex.com/index.php?api=fanyi&from=$from&to=$to&data=". urlencode($text);
        set_time_limit(0);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_MAXREDIRS,20);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 40);
        curl_setopt($ch, CURLOPT_URL, $url);
        $result = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($result);
        if($result['code']==1){
            $this->error = $result['msg'];
            return false;
        }else{
            return $result['data'];
        }
    }

    function fy($data){
        $zh_en=$this->translate($data,'zh-CN','EN');
        if($zh_en){

            $en_zh=$this->translate($zh_en,'EN','zh-CN');
            if($en_zh){
                $info=$en_zh;
                return $info;
            }else{
                JsonReturn(['id'=>0,'target'=>'','desc'=>'','error'=>'翻译内容太多或者操作太频繁!']);
            }
        }else{
            JsonReturn(['id'=>0,'target'=>'','desc'=>'','error'=>'翻译内容太多或者操作太频繁!']);
        }
    }

    function localimg($value,$tid=0,$molds=''){
        $webconfig = webConf();
        $web_basehost    = get_domain();
        if(isset($webconfig['admin_save_path'])){
            //替换日期事件
            $t = time();
            $d = explode('-', date("Y-y-m-d-H-i-s"));
            $format = $webconfig['admin_save_path'];
            $format = str_replace("{yyyy}", $d[0], $format);
            $format = str_replace("{yy}", $d[1], $format);
            $format = str_replace("{mm}", $d[2], $format);
            $format = str_replace("{dd}", $d[3], $format);
            $format = str_replace("{hh}", $d[4], $format);
            $format = str_replace("{ii}", $d[5], $format);
            $format = str_replace("{ss}", $d[6], $format);
            $format = str_replace("{time}", $t, $format);
            if($format!=''){
                //检查文件是否存在
                if(strpos($format,'/')!==false && !file_exists(APP_PATH.$format)){
                    $path = explode('/',$format);
                    $path1 = APP_PATH;
                    foreach($path as $v){
                        if($path1==APP_PATH){
                            if(!file_exists($path1.$v)){
                                mkdir($path1.$v,0777);
                            }
                            $path1.=$v;
                        }else{
                            if(!file_exists($path1.'/'.$v)){
                                mkdir($path1.'/'.$v,0777);
                            }
                            $path1.='/'.$v;
                        }
                    }
                }else if(!file_exists(APP_PATH.$format)){
                    mkdir(APP_PATH.$format,0777);
                }
                $admin_save_path = $format;

            }else{
                $admin_save_path = 'public/Admin';
            }


        }else{
            $admin_save_path = 'public/Admin';
        }
        $dirname =  $admin_save_path.'/';
        $imgUrl = trim($value);
        //  $imgUrl = preg_replace('/\\\"/', '', $imgUrl); //img 被转义的数据
        $imgUrl = preg_replace('/#/', '', $imgUrl);

        // 本站图片 / 根网址图片 / 第三方存储插件的图片
        if (preg_match("/\/\/('.$web_basehost.')\//i", $imgUrl)) {
            return $value;
        }
        // 不是合法链接
        if (!preg_match("#^http(s?):\/\/#i", $imgUrl)) {
            return $value;
        }

        $heads = @get_headers($imgUrl, 1);

        // 获取请求头并检测死链
        if (empty($heads)) {
            return $value;
        } else if (!(stristr($heads[0], "200") && !stristr($heads[0], "304"))) {
            return $value;
        }
        // 图片扩展名
        $fileType = substr($heads['Content-Type'], -4, 4);
        if (!preg_match("#\.(jpg|jpeg|gif|png|ico|bmp|webp|svg)#i", $fileType)) {
            if ($fileType == 'image/gif') {
                $pix = "gif";
            } else if ($fileType == 'image/png') {
                $pix = "png";
            } else if ($fileType == 'image/x-icon') {
                $pix = "ico";
            } else if ($fileType == 'image/bmp') {
                $pix = "bmp";
            }  else if ($fileType == 'image/webp') {
                $pix = "webp";
            } else if ($heads['Content-Type'] == 'image/svg+xml') {
                $pix = "svg";
            } else {
                $pix = 'jpg';
            }
        }
        $pix = strtolower($pix);

        //打开输出缓冲区并获取远程图片
        ob_start();
        $context = stream_context_create(
            array('http' => array(
                'follow_location' => false // don't follow redirects
            ))
        );
        readfile($imgUrl, false, $context);
        $img = ob_get_contents();
        ob_end_clean();
        preg_match("/[\/]([^\/]*)[\.]?[^\.\/]*$/", $imgUrl, $m);

        $file             = [];
        $file['oriName']  = $m ? $m[1] : "";
        $file['filesize'] = strlen($img);
        $file['ext']      = $pix;
        $file['name']     = date("ymdHis") . mt_rand(100, 999) .'.'. $file['ext'];
        $file['fullName'] = $dirname . $file['name'];
        $fullName         = $file['fullName'];

        //检查文件大小是否超出限制
        if ($file['filesize'] >= 20480000) {
            return $value;
        }

        //移动文件
        if (!(file_put_contents($fullName, $img) && file_exists($fullName))) { //移动失败
            return $value;
        }
        //处理水印
        if( (strtolower($pix)=='png' || strtolower($pix)=='jpg' || strtolower($pix)=='jpeg') && $webconfig['iswatermark']==1 ){
            watermark($file['fullName'],APP_PATH.$webconfig['watermark_file'],$webconfig['watermark_t'],$webconfig['watermark_tm'],$webconfig['text_word']);
        }


        $fileurl = '/'.$file['fullName'];
        $filesize = round(filesize(APP_PATH.$file['fullName'])/1024,2);
        M('pictures')->add(['litpic'=>'/'.$file['fullName'],'addtime'=>time(),'userid'=>$_SESSION['admin']['id'],'size'=>$filesize,'filetype'=>strtolower($pix),'tid'=>$tid,'molds'=>$molds]);
        return $fileurl;

    }






}