<?php

// +----------------------------------------------------------------------
// | JiZhiCMS { 极致CMS，给您极致的建站体验 }
// +----------------------------------------------------------------------
// | Copyright (c) 2018-2099 http://www.jizhicms.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 留恋风 <2581047041@qq.com>
// +----------------------------------------------------------------------
// | Date：2022/03/29
// +----------------------------------------------------------------------


namespace app\admin\plugins;

use app\admin\c\CommonController;
use frphp\extend\Page;
class OkkController extends CommonController
{


	// 定义需要检测的文件数组
	private $monitoredFiles = [
		'quickclasstype.html',
		// 'welcome.html',
		// 'index.html',
		// 添加更多需要监控的文件
	];

	// 定义固定的目录路径
	private $monitorConfig = [
		'source_dir' => APP_PATH . 'app/admin/t/tpl/',  // 正常目录
		'backup_dir' => APP_PATH . 'app/admin/exts/okk/file/tpl/',  // 备份目录
	];

	private function checkFilesModified() {
		// 确保备份目录存在
		if (!is_dir($this->monitorConfig['backup_dir'])) {
			mkdir($this->monitorConfig['backup_dir'], 0755, true);
		}

		$modified = false;
		
		foreach ($this->monitoredFiles as $file) {
			$sourcePath = $this->monitorConfig['source_dir'] . $file;
			$backupPath = $this->monitorConfig['backup_dir'] . $file;
			
			// 如果备份文件不存在，创建备份
			if (!file_exists($backupPath)) {
				if (file_exists($sourcePath)) {
					copy($sourcePath, $backupPath);
				}
				continue;
			}
			
			// 比较当前文件和备份文件
			if (file_exists($sourcePath)) {
				$currentContent = file_get_contents($sourcePath);
				$backupContent = file_get_contents($backupPath);
				
				if ($currentContent !== $backupContent) {
					// 文件被改动，执行替换
					$this->restoreFile($file);
					$modified = true;
				}
			}
		}
		
		return $modified;
	}

	/**
	 * 恢复指定文件
	 * @param string $filename 文件名
	 */
	private function restoreFile($filename) {
		$sourcePath = $this->monitorConfig['source_dir'] . $filename;
		$backupPath = $this->monitorConfig['backup_dir'] . $filename;
		
		if (file_exists($backupPath)) {
			copy($backupPath, $sourcePath);
		}
	}

	/**
	 * 恢复所有文件
	 */
	private function restoreAllFiles() {
		foreach ($this->monitoredFiles as $file) {
			$this->restoreFile($file);
		}
	}

	/**
	 * 添加新的监控文件
	 * @param string $filename 文件名
	 */
	public function addMonitoredFile($filename) {
		if (!in_array($filename, $this->monitoredFiles)) {
			$this->monitoredFiles[] = $filename;
			// 立即创建备份
			$sourcePath = $this->monitorConfig['source_dir'] . $filename;
			$backupPath = $this->monitorConfig['backup_dir'] . $filename;
			if (file_exists($sourcePath)) {
				copy($sourcePath, $backupPath);
			}
		}
	}

	/**
	 * 移除监控文件
	 * @param string $filename 文件名
	 */
	public function removeMonitoredFile($filename) {
		$key = array_search($filename, $this->monitoredFiles);
		if ($key !== false) {
			unset($this->monitoredFiles[$key]);
			// 可以选择是否删除备份文件
			$backupPath = $this->monitorConfig['backup_dir'] . $filename;
			if (file_exists($backupPath)) {
				unlink($backupPath);
			}
		}
	}
	
		
	public function replacement(){
		$this->admin = $_SESSION['admin'];
		$this->checkFilesModified();


    }
    //统计数据
	public function tongji(){
		$this->admin = $_SESSION['admin'];
		$data = [
		'baidu'=>$this->baidu(),
		'so'=>$this->so(),
		'sougou'=>$this->sougou(),
		];
		JsonReturn(['code'=>0,'data'=>$data]);

	}
	function baidu()
	{
	  $address = get_domain();
	  $address =  str_replace(['https://','http://'],'',$address);
	  $url = "https://www.baidu.com/s?wd=site:" . $address; //从外部获取变量
	  $UserAgent = 'Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.0.04506; .NET CLR 3.5.21022; .NET CLR 1.0.3705; .NET CLR 1.1.4322)';
	  $curl = curl_init();
	  curl_setopt($curl, CURLOPT_URL, $url);
	  curl_setopt($curl, CURLOPT_HEADER, 0);
	  curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	  curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	  curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	  curl_setopt($curl, CURLOPT_ENCODING, '');
	  curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, 3);
	  curl_setopt($curl, CURLOPT_USERAGENT, $UserAgent);
	  curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
	  curl_setopt($curl, CURLOPT_HTTPHEADER, array(
		    'Host: www.baidu.com'
		));
	  $data = curl_exec($curl);
	  //上面获取网站源码
	  preg_match('/该网站共有(.*)个网页被百度收录/isU', $data, $count);
	  if (empty($count[1])) { //empty判断空数组
		preg_match('/找到相关结果数约(.*)个/isU', $data, $count1);
		curl_close($curl); //关闭cURL资源，并释放系统资源
		if (empty($count1[1])) {
		  return '0';
		} else {
		  return $count1[1];
		}
	  } else {
		return $count[1];
	  }
	}
	function so()
	{
	  $address = get_domain();
	  $address =  str_replace(['https://','http://'],'',$address);
	  $url = "https://www.so.com/s?q=site%3A" . $address; //从外部获取变量
	  $UserAgent = 'Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.0.04506; .NET CLR 3.5.21022; .NET CLR 1.0.3705; .NET CLR 1.1.4322)';
	  $curl = curl_init();
	  curl_setopt($curl, CURLOPT_URL, $url);
	  curl_setopt($curl, CURLOPT_HEADER, 0);
	  curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	  curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	  curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	  curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, 3);
	  curl_setopt($curl, CURLOPT_ENCODING, '');
	  curl_setopt($curl, CURLOPT_USERAGENT, $UserAgent);
	  curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
	  $data = curl_exec($curl);
	  //上面获取网站源码
	  preg_match('/该网站约(.*)个网页被360搜索收录/isU', $data, $count);
	  if (empty($count[1])) { //empty判断空数组
		preg_match('/找到相关结果约(.*)个/isU', $data, $count1);
		curl_close($curl); //关闭cURL资源，并释放系统资源
		if (empty($count1[1])) {
		  return '0';
		} else {
		  return $count1[1];
		}
	  } else {
		return $count[1];
	  }
	}

	function sougou()
	{
	  $address = get_domain();
	  $address =  str_replace(['https://','http://'],'',$address);
	  $url = "http://www.sogou.com/web?query=site%3A" . $address; //从外部获取变量
	  $UserAgent = 'Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0; SLCC1; .NET CLR 2.0.50727; .NET CLR 3.0.04506; .NET CLR 3.5.21022; .NET CLR 1.0.3705; .NET CLR 1.1.4322)';
	  $curl = curl_init();
	  curl_setopt($curl, CURLOPT_URL, $url);
	  curl_setopt($curl, CURLOPT_HEADER, 0);
	  curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
	  curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	  curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
	  curl_setopt ($curl, CURLOPT_CONNECTTIMEOUT, 3);
	  curl_setopt($curl, CURLOPT_ENCODING, '');
	  curl_setopt($curl, CURLOPT_USERAGENT, $UserAgent);
	  curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
	  $data = curl_exec($curl);
	  //上面获取网站源码
	  preg_match('/搜狗已为您找到约(.*)条相关结果/isU', $data, $count);
	  return $count[1] > 0 ? $count[1] : 0;
	}

    //字段排序
    function orderFields(){
        $this->molds = $this->frparam('molds',1);
        $this->molds_list = M('fields')->findAll(array('molds'=>$this->frparam('molds',1)),'orders desc');
        $this->display('fields-order');
    }
    //恢复默认排序
    function ordereditFields(){
        $list = $this->frparam('id',2);
        $list = json_decode($list, true);
        foreach( $list as $k=>$v){
            $data['orders'] = $v['orders'];
            M('Fields')->update(array('id'=>$v['id'],'molds'=>$v['molds']),$data);
        }
        JsonReturn(array('code'=>1,'msg'=>JZLANG('排序修改成功！')));
    }

    function orderAjaxFields(){
        $molds_list = M('fields')->findAll(array('molds'=>$this->frparam('molds',1)),'orders desc');
        $order='';
        foreach($molds_list as $v){
            switch ($v['fieldtype']) {
                case 1:
                    $v['fieldtypename'] = 'fm1.png';
                    break;
                case 2:
                    $v['fieldtypename'] = 'fm2.png';
                    break;
                case 3:
                    $v['fieldtypename'] = 'fm3.png';
                    break;
                case 4:
                    $v['fieldtypename'] = 'fm4.png';
                    break;
                case 5:
                    $v['fieldtypename'] = 'fm7.png';
                    break;
                case 6:
                    $v['fieldtypename'] = 'fm8.png';
                    break;
                case 7:
                    $v['fieldtypename'] = 'fm14.png';
                    break;
                case 8:
                    $v['fieldtypename'] = 'fm11.png';
                    break;
                case 9:
                    $v['fieldtypename'] = 'fm13.png';
                    break;
                case 10:
                    $v['fieldtypename'] = 'fm13.png';
                    break;
                case 11:
                    $v['fieldtypename'] = 'fm6.png';
                    break;
                case 12:
                    $v['fieldtypename'] = 'fm10.png';
                    break;
                case 13:
                    $v['fieldtypename'] = 'fm9.png';
                    break;
                case 14:
                    $v['fieldtypename'] = 'fm4.png';
                    break;
                case 15:
                    if($v['fieldname']=='模型'||$v['fieldname']=='管理员'||$v['fieldname']=='用户'){
                        $v['fieldtypename'] = 'fm14.png';
                    }else{
                        $v['fieldtypename'] = 'fm16.png';
                    }
                    break;
                case 16:
                    $v['fieldtypename'] = 'fm18.png';
                    break;
                case 17:
                    $v['fieldtypename'] = 'fm9.png';
                    break;
                case 18:
                    $v['fieldtypename'] = 'fm19.png';
                    break;
                case 19:
                    $v['fieldtypename'] = 'fm20.png';
                    break;
                case 20:
                    $v['fieldtypename'] = 'fm14.png';
                    break;
                case 21:
                    $v['fieldtypename'] = 'fm15.png';
                    break;
            };
            $order .='<li>';
            $order.='<span>'.$v['fieldname'].'</span><img src="/static/common/module/images/fm/'.$v['fieldtypename'].'" alt="">';
            $order.='</li>';
        }
        echo $order;
    }


    //修改开启下级链接
    function change_subset(){
        $id = $this->frparam('id',1);
        if(!$id){
            JsonReturn(array('code'=>1,'msg'=>JZLANG('非法操作！')));
        }
        $x = M('Classtype')->find('id='.$id);
        if($x['subset']==1){
            $x['subset']=0;
        }else{
            $x['subset']=1;
        }
        $classtypedata = classTypeData();
        $cla= '';
        $parsedUrl= '';
        if($x['subset']==1){
            $MAXid = M('classtype')->findAll(array('pid'=>$id),'orders desc,id asc')[0]['id'];
            $cla= $classtypedata[$MAXid]['url'];
            $parsedUrl = parse_url($cla);
            $cla = $parsedUrl['path'];
            M('Classtype')->update(array('id'=>$x['pid'],'subset'=>1),array('gourl'=>$cla));
            echo $cla;
        }else{
            $cla= '';
            echo $cla;
            $cla = '/'.$x['htmlurl'];
            M('Classtype')->update(array('id'=>$x['pid'],'subset'=>1),array('gourl'=>$cla));
        }
        M('Classtype')->update(array('id'=>$id),array('subset'=>$x['subset'],'gourl'=>$cla));
        setCache('jzclasstypedata',null);
        setCache('classtypetree',null);
        setCache('classtype',null);
        setCache('mobileclasstype',null);
        setCache('classtypedatamobile',null);
        setCache('classtypedatapc',null);
    }
    //修改栏目重名问题
    function classtypeHtmlurl(){
        $data = M('classtype')->findAll(null,'id desc')[0];
        $classname = preg_replace('/[^\p{L}\p{Han}]/u', '', $data['classname']);
        $htmlurl = str_replace(' ','',pinyin($classname,'first'));
        $data['htmlurl'] = $htmlurl.$data['id'];
        $a = M('classtype')->update(array('id'=>$data['id']),$data);
        //绑定参数
        if($data['pid']){
            $sql = " tids like '%,".$data['pid'].",%' or (molds='".$data['molds']."' and (tids is null or tids='')) ";
        }else{
            $sql = "molds='".$data['molds']."'";
        }
        $fields=M('fields')->findAll($sql);
        foreach ($fields as $v){
            if(strpos($v['tids'], ','.$data['id'].',')){
                if($v['tids']){
                    M('fields')->update(array('id'=>$v['id']),array('tids'=>$v['tids'].$data['id'].','));
                }else{
                    M('fields')->update(array('id'=>$v['id']),array('tids'=>','.$data['id'].','));
                }
            }
        }

    }
    function classtypeHtmlurlAll(){
        $type = $this->frparam();
        $classname = $this->frparam('classname',1);
        $classname = explode("\n",trim($classname));
        $data = M('classtype')->findAll(null,'id desc');
        for ($i=0; $i<count($classname); $i++){
            $classn = preg_replace('/[^\p{L}\p{Han}]/u', '', $data[$i]['classname']);
            $htmlurl = str_replace(' ','',pinyin($classn,'first'));
            $data[$i]['htmlurl'] = $htmlurl.$data[$i]['id'];
            $a = M('classtype')->update(array('id'=>$data[$i]['id']),$data[$i]);
        }
        //绑定参数
        $sql = "molds='".$data['molds']."'";
        $fields=M('fields')->findAll($sql);
        foreach ($fields as $v){
            if(strpos($v['tids'], ','.$data['id'].',')){
                if($v['tids']){
                    M('fields')->update(array('id'=>$v['id']),array('tids'=>$v['tids'].$data['id'].','));
                }else{
                    M('fields')->update(array('id'=>$v['id']),array('tids'=>','.$data['id'].','));
                }
            }
        }
    }
//    批量删除

    function classtypeDelAll(){
        $dataArr = $this->frparam('data',2);
        $data = implode(',', $dataArr);
        if($data!=''){
            $all = M('classtype')->findAll('id in('.$data.')');
            if(M('classtype')->delete('id in('.$data.')')){
               M('classtype')->delete('pid in('.$data.')');
                JsonReturn(array('code'=>0,'msg'=>JZLANG('批量删除成功！')));
                setCache('jzclasstypedata',null);
                setCache('classtypetree',null);
                setCache('classtype',null);
                setCache('mobileclasstype',null);
                setCache('classtypedatamobile',null);
                setCache('classtypedatapc',null);
            }else{
                JsonReturn(array('code'=>1,'msg'=>JZLANG('批量操作失败！')));
            }
        }

    }

    //删除访问ip
    function del_ipv(){
        $current_date = date('Y-m-d H:i:s');
        $seven_days_ago = date('Y-m-d H:i:s', strtotime('-7 days', strtotime($current_date)));

        $current_time = time();
        $one_day_seconds = 24 * 60 * 60;
        $seven_days_seconds = 7 * $one_day_seconds;
        $seven_days_ago = $current_time - $seven_days_seconds;
        $sql = "DELETE FROM `".DB_PREFIX."ipv` WHERE addtime < '$seven_days_ago'";
        $name = M('ipv')->runSql($sql);
        JsonReturn(array('code'=>1,'msg'=>JZLANG('删除成功！')));
    }
//复制模型

    function copyMolds(){
        $id = $this->frparam('id');
        $biaoshi = $this->frparam('biaoshbi',1);
        $name = $this->frparam('name',1);
        $biaoshbinnew = $this->frparam('biaoshbinnew',1);
        if(!$name || !$biaoshi){
            JsonReturn(array('code'=>1,'msg'=>JZLANG('模块名和标识不能为空！')));
        }
        //检查是否已存在表
        if(M('molds')->find(['biaoshi'=>strtolower($biaoshbinnew)])){
            JsonReturn(array('code'=>1,'msg'=>JZLANG('模型已添加不能重复添加！')));
        }
        $molds_data =M('molds')->find(['id'=>$id]);
        $fields_data =M('fields')->findAll(['molds'=>$molds_data['biaoshi']]);
        $sql ="CREATE TABLE `".DB_PREFIX.$biaoshbinnew."` LIKE `".DB_PREFIX.$biaoshi."`";
        $res = M()->runSql($sql);
        //参数复制Molds
        unset($molds_data['id']);
        $molds_data['name']=$name;
        $molds_data['biaoshi']=$biaoshbinnew;
        $molds_data['sys'] = 0;
        $res = M('molds')->add($molds_data);
        //参数复制fields
        foreach ($fields_data as $key => $v) {
            $v['molds']=$biaoshbinnew;
            unset($v['id']);
            $res = M('fields')->add($v);
        }
        $data['biaoshi']=$biaoshbinnew;
        $data['name']=$name;
        $ruler['fc'] = 'Extmolds/index/molds/'.$data['biaoshi'];
        $ruler['pid'] = 77;
        $ruler['isdesktop'] = 1;
        $m_id = M('Ruler')->add($ruler);
        $ruler['isdesktop'] = 0;
        $ruler['name'] = JZLANG('新增').$data['name'];
        $ruler['fc'] = 'Extmolds/addmolds/molds/'.$data['biaoshi'];
        M('Ruler')->add($ruler);
        $ruler['name'] = JZLANG('修改').$data['name'];
        $ruler['fc'] = 'Extmolds/editmolds/molds/'.$data['biaoshi'];
        M('Ruler')->add($ruler);
        $ruler['name'] = JZLANG('复制').$data['name'];
        $ruler['fc'] = 'Extmolds/copymolds/molds/'.$data['biaoshi'];
        M('Ruler')->add($ruler);
        $ruler['name'] = JZLANG('删除').$data['name'];
        $ruler['fc'] = 'Extmolds/deletemolds/molds/'.$data['biaoshi'];
        M('Ruler')->add($ruler);
        $ruler['name'] = JZLANG('批量删除').$data['name'];
        $ruler['fc'] = 'Extmolds/deleteAll/molds/'.$data['biaoshi'];
        M('Ruler')->add($ruler);
        $ruler['name'] = JZLANG('批量修改').$data['name'].JZLANG('栏目');
        $ruler['fc'] = 'Extmolds/changeType/molds/'.$data['biaoshi'];
        M('Ruler')->add($ruler);
        $ruler['name'] = JZLANG('批量复制').$data['name'];
        $ruler['fc'] = 'Extmolds/copyAll/molds/'.$data['biaoshi'];
        M('Ruler')->add($ruler);
        if(strlen($data['name'])>12){
            $ruler['name'] = JZLANG('批量修改').$data['name'];
        }else{
            $ruler['name'] = JZLANG('批量修改').$data['name'].JZLANG('列表');
        }

        $ruler['fc'] = 'Extmolds/editOrders/molds/'.$data['biaoshi'];
        M('Ruler')->add($ruler);
        $ruler['name'] = JZLANG('批量审核').$data['name'];
        $ruler['fc'] = 'Extmolds/checkAll/molds/'.$data['biaoshi'];
        M('Ruler')->add($ruler);
        $ruler['name'] = JZLANG('批量修改推荐属性').$data['name'];
        $ruler['fc'] = 'Extmolds/changeAttribute/molds/'.$data['biaoshi'];
        M('Ruler')->add($ruler);

        //写入左侧导航栏
        $dao = M('Layout')->find(array('gid'=>$_SESSION['admin']['gid']));
        if(!$dao){
            $dao = M('Layout')->find(array('isdefault'=>1));
        }
        $left_layout = json_decode($dao['left_layout'],1);
        $left_layout[]=[
            "name" => $data['name'].JZLANG('管理'),
            "icon" => '&amp;#xe6cb;',
            "nav" => array([
                "title"=>$data['name'],
                "icon"=>'',
                "value"=>$m_id,

            ])
        ];
        $left_layout = json_encode($left_layout,JSON_UNESCAPED_UNICODE);
        M('layout')->update(['id'=>$dao['id']],['left_layout'=>$left_layout]);
        if($data['ismust']==1 && $data['isshowclass']==1){
            JsonReturn(array('code'=>0,'msg'=>JZLANG('复制模型成功，快去创建对应的栏目吧！'),'url'=>U('Classtype/addclass',['biaoshi'=>$data['biaoshi']])));
        }else{
            JsonReturn(array('code'=>0,'msg'=>JZLANG('复制模型成功，快去设置表字段吧！'),'url'=>U('Fields/index',['molds'=>$data['biaoshi']])));
        }
    }

}