<?php

// +----------------------------------------------------------------------
// | JiZhiCMS { 极致CMS，给您极致的建站体验 }  
// +----------------------------------------------------------------------
// | Copyright (c) 2018-2099 http://www.jizhicms.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 留恋风 <2581047041@qq.com>
// +----------------------------------------------------------------------
// | Date：2023/11/09
// +----------------------------------------------------------------------

namespace app\admin\exts;

use frphp\lib\Controller;
class PluginsController extends Controller {
	
	private $tables = array();
	private $handler;
	public function _init(){
		/**
			继承系统默认配置
		
		**/
		
		//检查当前账户是否合乎操作
		if(!isset($_SESSION['admin']) || $_SESSION['admin']['id']==0){
			Redirect(U('Login/index'));
			
		}
 
	    if($_SESSION['admin']['isadmin']!=1){
			if(strpos($_SESSION['admin']['paction'],','.APP_CONTROLLER.',')!==false){
			}else{
				$action = APP_CONTROLLER.'/'.APP_ACTION;
				if(strpos($_SESSION['admin']['paction'],','.$action.',')===false){
				   $ac = M('Ruler')->find(array('fc'=>$action));
				   if($this->frparam('ajax')){
					   
					   JsonReturn(['code'=>1,'msg'=>'您没有【'.$ac['name'].'】的权限！','url'=>U('Index/index')]);
				   }
				   Error('您没有【'.$ac['name'].'】的权限！',U('Index/index'));
				}
			}
		   
		  	
		}
	  	
	    $webconf = webConf();
	    $this->webconf = $webconf;
	    $customconf = get_custom();
	    $this->customconf = $customconf;
		
		//插件模板页目录
		
		$this->tpl = '@'.dirname(__FILE__).'/tpl/';
		
		/**
			在下面添加自定义操作
		**/
		 
		
	}
	
	//执行SQL语句在此处处理,或者移动文件也可以在此处理
	public  function install(){
		//转移文件
        $dir = APP_PATH.APP_HOME.'/exts/okk/file/module';
        $to = APP_PATH.'/static/common/module';
        $this->recurse_copy($dir,$to);


        $dir = APP_PATH.APP_HOME.'/t/tpl';
        $to = APP_PATH.APP_HOME.'/t/tpl_old';
        $this->recurse_copy($dir,$to);



        $dir = APP_PATH.APP_HOME.'/exts/okk/file/tpl';
        $to = APP_PATH.APP_HOME.'/t/tpl';
        $this->recurse_copy($dir,$to);


		$tables = $this->getTableData();
		if(!in_array(DB_PREFIX.'ipv',$tables)){
			$sql="CREATE TABLE `".DB_PREFIX."ipv` (
					  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
                   `tid` int(11) DEFAULT '0' COMMENT '所属栏目',
                   `tids` varchar(255) DEFAULT NULL COMMENT '副栏目',
                   `title` varchar(255) DEFAULT NULL COMMENT '标题',
                   `litpic` varchar(255) DEFAULT NULL COMMENT '缩略图',
                   `keywords` varchar(255) DEFAULT NULL COMMENT '关键词',
                   `description` varchar(500) DEFAULT NULL COMMENT '简介',
                   `body` text COMMENT '内容',
                   `molds` varchar(50) DEFAULT 'ipv' COMMENT '模型标识',
                   `member_id` int(11) DEFAULT '0' COMMENT '前台用户',
                   `comment_num` varchar(255) DEFAULT '0',
                   `htmlurl` varchar(100) DEFAULT NULL COMMENT '栏目链接',
                   `isshow` tinyint(1) DEFAULT '1' COMMENT '是否显示',
                   `target` varchar(255) DEFAULT NULL COMMENT '外链',
                   `ownurl` varchar(255) DEFAULT NULL COMMENT '自定义URL',
                   `jzattr` varchar(50) DEFAULT NULL COMMENT '推荐属性',
                   `hits` int(11) DEFAULT '0' COMMENT '点击量',
                   `addtime` int(11) DEFAULT '0' COMMENT '发布时间',
                   `orders` int(11) NOT NULL DEFAULT '0',
					  PRIMARY KEY (`id`)
					) ;";
        	M()->runSql($sql);
		}
        $a = M('fields')->find(['fieldname'=>'subset','molds'=>'classtype']);
        if(!$a){
        $classtypeid = M('classtype')->findAll('','','id');
        $idItem= ','. implode(',', array_column($classtypeid, 'id')). ',';
            $data = array(
             
                'field' =>'subset',
                'molds' => 'classtype',
                'fieldname' =>'subset',
                'tips' => '',
                'fieldtype' => 12,
                'tids' => $idItem,
                'fieldlong' => 500,
                'body' => '开启=1,关闭=0',
                'orders' => 0,
                'ismust' => 0,
                'isshow' => 1,
                'isadmin' => 1,
                'issearch' => 0,
                'islist' => 0,
                'format' => '不做处理',
                'vdata' => '',
                'isajax' => 1,
                'listorders' => 0,
                'isext' => 0,
                'width' => '',
                'ishome' => 1
            );
            M('fields')->add($data);
            $sql = "ALTER TABLE `".DB_PREFIX."classtype` ADD COLUMN subset VARCHAR(500) DEFAULT '0' COMMENT '开启下级链接'";
            M()->runSql($sql);
        }
		

		
        if(!M('hook')->find(['plugins_name'=>'okk'])){
            //注册到hook里面
            $w['module'] = 'home';
            $w['namespace'] = 'home';
            $w['controller'] = 'Home';
            $w['action'] = '';
            $w['all_action'] = 1;
            $w['hook_namespace'] = 'home';
            $w['hook_controller'] = 'Okk';
            $w['hook_action'] = 'Okk';
            $w['plugins_name'] = 'okk';//插件文件夹
            $w['addtime'] = time();
            M('hook')->add($w);
            $w['controller'] = 'User';
            M('hook')->add($w);
            $w['controller'] = 'Comment';
            M('hook')->add($w);
            $w['controller'] = 'Message';
            M('hook')->add($w);
            $w['controller'] = 'Login';
            M('hook')->add($w);
            $w['controller'] = 'Qq';
            M('hook')->add($w);
			
			//注册hook
			$ww = [];
			$ww['module'] = 'admin';
			$ww['controller'] = 'Index';
			$ww['action'] = 'index';
			$ww['hook_controller'] = 'Okk';
			$ww['hook_action'] = 'replacement';
			$ww['all_action'] = 0;
			$ww['isopen'] = 1;
			$ww['plugins_name'] = 'okk';
			$ww['addtime'] = time();
			M('hook')->add($ww);
            setCache('hook',null);
        }

        // 配置权限
        if(!M('ruler')->find(['fc'=>'Okk'])){
            $pid = M('ruler')->add(['fc'=>'Okk','name'=>'Okk主题','sys'=>0]);
            M('ruler')->add(['fc'=>'Okk/index','name'=>'Okk主页','pid'=>$pid,'sys'=>0]);
            M('ruler')->add(['fc'=>'Okk/setConfigPath','name'=>'Okk配置','pid'=>$pid,'sys'=>0]);
            M('ruler')->add(['fc'=>'Okk/tongji','name'=>'统计','pid'=>$pid,'sys'=>0]);
            M('ruler')->add(['fc'=>'Okk/tongji','name'=>'统计','pid'=>$pid,'sys'=>0]);
        }

		return true;
		
	}
	
	//卸载程序,对新增字段、表等进行删除SQL操作，或者其他操作
	public function uninstall(){
        @unlink(APP_PATH.APP_HOME.'/t/tpl/fields-order.html');
        $dir = APP_PATH.APP_HOME.'/t/tpl_old';
        $to = APP_PATH.APP_HOME.'/t/tpl';
        $this->recurse_copy($dir,$to);
        // 删除 custom.html 文件
        @unlink(APP_PATH.APP_HOME.'/t/tpl/custom.html');
        
        if (is_dir($dir)) {
            rmdir($dir);
        }
		//栏目插件
        if (M('plugins')->find(['filepath'=>'quickclasstype'])) {
			$dir = APP_PATH.APP_HOME.'/exts/quickclasstype/file/quickclasstype.html';
			$to = APP_PATH.APP_HOME.'/t/tpl/quickclasstype.html';
			copy($dir,$to);
        }
		
		M('hook')->delete(['plugins_name'=>'okk']);
		setCache('hook',null);
		
		return true;
	}
	
	//批量转移文件
	private function removeFile($from,$to){
		//移动后台插件控制器
		$sourcefile = $from;
		$target = $to;
		if(is_dir($sourcefile) && is_dir($target)){
			if (false != ($handle = opendir ( $sourcefile ))) {
				
				while ( false !== ($file = readdir ( $handle )) ) {
					//去掉"“.”、“..”以及带“.xxx”后缀的文件
					if ($file != "." && $file != ".." && !is_dir($sourcefile.'/'.$file) ) {
						$fs = $sourcefile.'/'.$file;
						$ft = $target.'/'.$file;
						 //备份源文件以防更新覆盖
						copy($ft,  $sourcefile.'/back/'.$file);
						$r = $this->file2dir($fs,$ft);
						if(!$r){
							JsonReturn(array('code'=>1,'msg'=>'文件转移失败！sourcefile:'.$fs.' targetfile:'.$ft));
						}
					}
				}
				//关闭句柄
				closedir ( $handle );
			}
		
		}
				
	}
	
	// 原目录，复制到的目录
	function recurse_copy($src,$dst) {  
	 
		$dir = opendir($src);
		@mkdir($dst);
		while(false !== ( $file = readdir($dir)) ) {
			if (( $file != '.' ) && ( $file != '..' )) {
				if ( is_dir($src . '/' . $file) ) {
					$this->recurse_copy($src . '/' . $file,$dst . '/' . $file);
				}
				else {
					copy($src . '/' . $file,$dst . '/' . $file);
				}
			}
		}
		closedir($dir);
	}
	//复制文件并转移
	function file2dir($sourcefile, $filename){
		 if( !file_exists($sourcefile)){
			 return false;
		 }
		 //$filename = basename($sourcefile);
		
		 return copy($sourcefile,  $filename);
	}
	
	//返回表字段
	private function getTableFields($table){
		if(defined('DB_TYPE') && DB_TYPE=='sqlite'){
			$sql = "pragma table_info(".DB_PREFIX.$table.")";
			
			$list = M()->findSql($sql);
			$fields = [];
			foreach($list as $v){
				$fields[]=$v['name'];
				
			}
		}else{
			$sql = 'SHOW COLUMNS FROM '.DB_PREFIX.$table;
			$list = M()->findSql($sql);
			$isgo = true;
			$fields = [];
			foreach($list as $v){
				$fields[]=$v['Field'];
				
			}
		}
		
		
		
		return $fields;
		
	}
	//返回数据库表
	private function getTableData(){
		if(defined('DB_TYPE') && DB_TYPE=='sqlite'){
			$sql = "select name from sqlite_master where type='table' order by name";
		}else{
			$sql = "SHOW TABLES";
		}
		$tables = M()->findSql($sql);
		$ttable = array();
		foreach($tables as $value){
			foreach($value as $vv){
				$ttable[] = $vv;
			}
		}
		return $ttable;
	}

	
	
	//安装页面介绍,操作说明
	public function desc(){
		$this->display($this->tpl.'plugins-description.html');
	}
	
	//配置文件,插件相关账号密码等操作
	public  function setconf($plugins){
		//将插件赋值到模板中
		$this->plugins = $plugins;
		$this->config = json_decode($plugins['config'],1);
		
		$this->display($this->tpl.'plugins-body.html');
	}
	
	//获取插件内提交的数据处理
	public function setconfigdata($data){
		//ids
		
		$config = $data;

		M('plugins')->update(['id'=>$data['id']],['config'=>json_encode($config,JSON_UNESCAPED_UNICODE)]);
		setCache('hook',null);//清空hook缓存
		JsonReturn(['code'=>0,'msg'=>'设置成功！']);
	}

	
}




