<?php

// +----------------------------------------------------------------------
// | JiZhiCMS { 极致CMS，给您极致的建站体验 }  
// +----------------------------------------------------------------------
// | Copyright (c) 2018-2099 http://www.jizhicms.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 留恋风 <2581047041@qq.com>
// +----------------------------------------------------------------------
// | Date：2022/02/18
// +----------------------------------------------------------------------


namespace A\plugins;


use A\c\CommonController;
use FrPHP\Extend\Page;
class MutiwebController extends CommonController
{
	public function index(){
		
		$page = new Page('lang');
		$sql = ' 1=1 ';

		$data = $page->where($sql)->orderby('id asc')->page($this->frparam('page',0,1))->go();
		$pages = $page->pageList();
		$this->pages = $pages;
		$this->lists = $data;
		$this->sum = $page->sum;
		$this->display('mutiweb-list');
        exit;
	}
	
	public function addweb(){
		$id = $this->frparam('id');
		$name = $this->frparam('name',1);
		$lang = $this->frparam('lang',1);
		
		if(!$name || !$lang){
			
			JsonReturn(['code'=>1,'msg'=>JZLANG('区域描述和区域标识不能为空！')]);
		}
		if(strlen($name)>50){
			JsonReturn(['code'=>1,'msg'=>JZLANG('区域描述太长！')]);
		}
		if(strlen($lang)>10){
			JsonReturn(['code'=>1,'msg'=>JZLANG('区域标识太长！')]);
		}
		if(M('lang')->find(['lang'=>$lang])){
			JsonReturn(['code'=>1,'msg'=>JZLANG('区域标识已存在！')]);
		}
		
		$res = M('lang')->add([
			'name'=>$name,
			'lang'=>$lang,
			'web_name'=>$this->frparam('web_name',1),
			'web_keyword'=>$this->frparam('web_keyword',1),
			'web_desc'=>$this->frparam('web_desc',1),
			'web_tel'=>$this->frparam('web_tel',1),
			'web_address'=>$this->frparam('web_address',1),
			'web_qq'=>$this->frparam('web_qq',1),
			'web_email'=>$this->frparam('web_email',1),
			'pc_template'=>$this->frparam('pc_template',1),
		]);
		if($res){
			if($id){
				$lb = M('lang')->getField(['id'=>$id],'lang');
				$class = M('classtype')->findAll(['lang'=>$lb],'id asc');
				$num = strlen($lb);
				foreach($class as $k=>$v){
					$w = $v;
					$w['lang'] = $lang;
					unset($w['id']);
					$html = $lb==APP_LANG ? '/'.$v['htmlurl'] : substr($v['htmlurl'],$num);
					$w['htmlurl'] = $lang.$html;
					$r = M('classtype')->add($w);
					$class[$k]['jztid'] = $r;
				}
				//处理层级关系
				$newtree = [];
				foreach($class as $k=>$v){
					$newtree[$v['id']] = $v;
				}
				foreach($class as $k=>$v){
					if($v['pid']!=0){
						M('classtype')->update(['id'=>$v['jztid']],['pid'=>$newtree[$v['pid']]['jztid']]);
					}
					
				}
				
				
				setCache('classtypetree',null);
				setCache('classtype',null);
				setCache('mobileclasstype',null);
				setCache('classtypedatamobile',null);
				setCache('classtypedatapc',null);
				
			}
			
			JsonReturn(['code'=>0,'msg'=>JZLANG('创建区域成功！')]);
		}
		
		JsonReturn(['code'=>1,'msg'=>JZLANG('创建区域失败！')]);
		
		
	}

	public function editweb(){
		$id = $this->frparam('id');
		$name = $this->frparam('name',1);
		$lang = $this->frparam('lang',1);
		
		if(!$name || !$lang || !$id){
			JsonReturn(['code'=>1,'msg'=>JZLANG('参数错误！')]);
		}
		if(strlen($name)>50){
			JsonReturn(['code'=>1,'msg'=>JZLANG('区域描述太长！')]);
		}
		if(strlen($lang)>10){
			JsonReturn(['code'=>1,'msg'=>JZLANG('区域标识太长！')]);
		}
		$old = M('lang')->find(['id'=>$id]);
		if($old['lang']==APP_LANG && $old['lang']!=$lang){
			JsonReturn(['code'=>1,'msg'=>JZLANG('中文cn标识不允许修改！')]);
		}
		
		$res = M('lang')->update(['id'=>$id],[
		'name'=>$name,
		'lang'=>$lang,
		'web_name'=>$this->frparam('web_name',1),
		'web_keyword'=>$this->frparam('web_keyword',1),
		'web_desc'=>$this->frparam('web_desc',1),
		'web_tel'=>$this->frparam('web_tel',1),
		'web_address'=>$this->frparam('web_address',1),
		'web_qq'=>$this->frparam('web_qq',1),
		'web_email'=>$this->frparam('web_email',1),
		'pc_template'=>$this->frparam('pc_template',1),
		]);
		if($res){
			if($old['lang']!=$lang){
				$list = M('classtype')->findAll(['lang'=>$old['lang']]);
				$num = strlen($old['lang']);
				foreach($list as $v){
					
					$w['lang'] = $lang;
					$html = substr($v['htmlurl'],$num);
					$w['htmlurl'] = $lang.$html;
					M('classtype')->update(['id'=>$v['id']],$w);
					//更改对应栏目的内容URL
					M($v['molds'])->update(['tid'=>$v['id']],['htmlurl'=>$w['htmlurl']]);
					
					
				}
				setCache('classtypetree',null);
				setCache('classtype',null);
				setCache('mobileclasstype',null);
				setCache('classtypedatamobile',null);
				setCache('classtypedatapc',null);
				
			}
			JsonReturn(['code'=>0,'msg'=>JZLANG('修改区域成功！')]);
		}
		JsonReturn(['code'=>1,'msg'=>JZLANG('修改区域失败！')]);
		
		
	}

	public function getweb(){
		$id = $this->frparam('id');
		$web = M('lang')->find(['id'=>$id]);
		JsonReturn(['code'=>0,'msg'=>'success','data'=>$web]);
		
	}

	public function delweb(){
		$id = $this->frparam('id');
		if(!$id){
			JsonReturn(['code'=>1,'msg'=>JZLANG('ID不存在！')]);
		}
		$res = M('lang')->find(['id'=>$id]);
		if(!$res){
			JsonReturn(['code'=>1,'msg'=>JZLANG('区域已删除，请勿重复操作！')]);
		}
		$r = M('lang')->delete(['id'=>$id]);
		if($r){
			$list = M('classtype')->findAll(['lang'=>$res['lang']]);
			foreach($list as $v){
				$w['molds'] = 'classtype';
				$w['data'] = serialize($v);
				$w['addtime'] = time();
				M('recycle')->add($w);
				$rr = M($v['molds'])->findAll(['tid'=>$v['id']]);
				foreach($rr as $vv){
					$w['molds'] = $v['molds'];
					$w['data'] = serialize($vv);
					$w['addtime'] = time();
					M('recycle')->add($w);
					
				}
				M($v['molds'])->delete(['tid'=>$v['id']]);
				M('classtype')->delete(['id'=>$v['id']]);
			}
			JsonReturn(['code'=>0,'msg'=>JZLANG('操作成功！')]);
			
			
		}else{
			JsonReturn(['code'=>1,'msg'=>JZLANG('删除失败，请重试！')]);
		}
		
		
		
	}

	//首页导航
    public function home(){
        
        if($this->frparam('web',1)){
            $_SESSION['web'] = $this->frparam('web',1);
            $this->web_name = M('lang')->getField(['lang'=>$_SESSION['web']],'name');
            $this->display('mutiweb-going');
            exit;
            
        }
        
        $web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
        $this->web_name = M('lang')->getField(['lang'=>$web],'name');
        if($web==APP_LANG){
            $homeurl = '/';
        }else{
            $homeurl = '/'.$web.'/index.html';
        }
        $this->homeurl = $homeurl;
        
        $this->admin = $_SESSION['admin'];
        $desktop = M('Layout')->find(array('gid'=>$_SESSION['admin']['gid']));
        if(!$desktop){
            $desktop = M('Layout')->find(array('isdefault'=>1));
        }
        
        $this->left_layout = json_decode($desktop['left_layout'],true);
        $this->top_layout = json_decode($desktop['top_layout'],true);
        $this->top_num = count($this->top_layout);
        $rulers = M('Ruler')->findAll(array('isdesktop'=>1));
        $actions = array();
        foreach($rulers as $k=>$v){
            $actions[$v['id']] = $v;
        }
        $this->actions = $actions;
        $classnav = [];
        foreach($this->classtypetree as $v){
            $k = 'class_'.$v['id'];
            if($v['molds']=='page'){
                $v['act'] = U('classtype/editclass',['id'=>$v['id']]);
            }else if($v['molds']=='article'){
                $v['act'] = U('article/articlelist',['tid'=>$v['id']]);
            }else if($v['molds']=='product'){
                $v['act'] = U('product/productlist',['tid'=>$v['id']]);
            }else if($v['molds']=='message'){
                $v['act'] = U('message/messagelist',['tid'=>$v['id']]);
            }else{
                $v['act'] = U('extmolds/index',['molds'=>$v['molds'],'tid'=>$v['id']]);
            }
            $classnav[$k] = $v;
        }
        $this->classnav = $classnav;
        $this->display('mutiweb');
        exit;
    }
    //欢迎页
    public function welcome(){
        $web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
        $this->web_name = M('lang')->getField(['lang'=>$web],'name');
        $this->isadmin = $_SESSION['admin']['isadmin'];
        $this->web = $web;
        
        $allclass = M('classtype')->findAll(['lang'=>$web],null,null,null);
        $ids = [0];
        foreach($allclass as $v){
            $ids[]=$v['id'];
        }
        $this->ids = implode(',',$ids);
        
        //计算站内信息
        $member_count = M('member')->getCount();
        $this->member_count = $member_count;
        
        $this->article_num = M('article')->getCount();
        $this->product_num = M('product')->getCount();
        $this->message_num = M('message')->getCount();
        if(defined('TPL_PATH')){
            $path = TPL_PATH;
        }else{
            $path = APP_HOME;
        }
        $includefile = str_replace('//','/',APP_PATH . $path .'/'.HOME_VIEW.'/'.Tpl_template.'/custom.html');
        if(file_exists($includefile)){
            $this->display('custom');
        }else{
            $this->display('mutiweb-welcome');
        }
        exit;
    }
    
    //内容管理
	public function articlelist(){
		$page = new Page('Article');
		$classtypedata = $this->classtypedata;
		$this->fields_list = M('Fields')->findAll(array('molds'=>'article','islist'=>1),'listorders desc');
		$this->isshow = $this->frparam('isshow');
		$this->tid=  $this->frparam('tid');
		$this->title = $this->frparam('title',1);
		$this->molds = M('molds')->find(['biaoshi'=>'article']);
		$this->classtypes = $this->classtypetree;
		$data = $this->frparam();
		$res = molds_search('article',$data);
		$get_sql = ($res['fields_search_check']!='') ? (' and '.$res['fields_search_check']) : '';
		$this->fields_search = $res['fields_search'];
		
		if($this->frparam('ajax')){
			$sql = ' 1=1 ';
			if($this->admin['classcontrol']==1 && $this->admin['isadmin']!=1 && $this->molds['iscontrol']!=0 && $this->molds['isclasstype']==1){
				$a1 = explode(',',$this->tids);
				$a2 = array_filter($a1);
				$tids = implode(',',$a2);
				$sql.=' and tid in('.$tids.') ';


			}
			$web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
			$allowclass = M('classtype')->findAll(['lang'=>$web]);
			$allow_tids = [0];
			foreach($allowclass as $v){
				$allow_tids[]=$v['id'];
			}
			$sql .= " and tid in (".implode(',',$allow_tids).") ";
			
			$sql .= $get_sql;
			$data = $page->where($sql)->orderby('orders desc,id desc')->limit($this->frparam('limit',0,10))->page($this->frparam('page',0,1))->go();
			$ajaxdata = [];
			foreach($data as $k=>$v){
				
				$v['view_url'] = gourl($v,$v['htmlurl']);
				$v['edit_url'] = U('Article/editarticle',array('id'=>$v['id']));
			
				foreach($this->fields_list as $vv){
					$v[$vv['field']] = format_fields($vv,$v[$vv['field']]);
				}
				$ajaxdata[]=$v;
				
			}
			$pages = $page->pageList();
			$this->pages = $pages;
			$this->lists = $data;
			$this->sum = $page->sum;
			
			JsonReturn(['code'=>0,'data'=>$ajaxdata,'count'=>$page->sum]);
			
		}
		
		
		$this->display('article-list');
		exit;
		
	}
	//商品管理
	public function productlist(){
		
		$classtypedata = $this->classtypedata;
		$this->molds = M('molds')->find(['biaoshi'=>'product']);
		$this->tid=  $this->frparam('tid');
		$this->title = $this->frparam('title',1);
		$this->isshow = $this->frparam('isshow');
		$data = $this->frparam();
		$res = molds_search('product',$data);
		$this->classtypes = $this->classtypetree;
		$this->fields_search = $res['fields_search'];
		$this->fields_list = M('Fields')->findAll(array('molds'=>'product','islist'=>1),'listorders desc');
		if($this->frparam('ajax')){
			
			$page = new Page('product');
			$sql = ' 1=1 ';
			if($this->admin['classcontrol']==1 && $this->admin['isadmin']!=1 && $this->molds['iscontrol']!=0 && $this->molds['isclasstype']==1){
				$a1 = explode(',',$this->tids);
				$a2 = array_filter($a1);
				$tids = implode(',',$a2);
				$sql.=' and tid in('.$tids.') ';


			}
			$web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
			$allowclass = M('classtype')->findAll(['lang'=>$web]);
			$allow_tids = [0];
			foreach($allowclass as $v){
				$allow_tids[]=$v['id'];
			}
			$sql .= " and tid in (".implode(',',$allow_tids).") ";
			
			$get_sql = ($res['fields_search_check']!='') ? (' and '.$res['fields_search_check']) : '';
			$sql .= $get_sql;
			
			
			$data = $page->where($sql)->orderby('orders desc,id desc')->limit($this->frparam('limit',0,10))->page($this->frparam('page',0,1))->go();
			
			$ajaxdata = [];
			foreach($data as $k=>$v){
				
				if(isset($classtypedata[$v['tid']])){
					$v['new_tid'] = $classtypedata[$v['tid']]['classname'];
				}else{
					$v['new_tid'] = '['.JZLANG('未分类').']';
				}
				
				$v['view_url'] = gourl($v,$v['htmlurl']);
				$v['edit_url'] = U('Product/editproduct',array('id'=>$v['id']));
				
				foreach($this->fields_list as $vv){
					$v[$vv['field']] = format_fields($vv,$v[$vv['field']]);
				}
				$ajaxdata[]=$v;
				
			}
			$pages = $page->pageList();
			$this->pages = $pages;
			$this->lists = $data;
			$this->sum = $page->sum;
			JsonReturn(['code'=>0,'data'=>$ajaxdata,'count'=>$page->sum]);
		}
		
		
		
		
		$this->display('product-list');
		exit;
		
	}
	//扩展模块
	public function extmoldsindex(){
		
		$classtypedata = $this->classtypedata;
		$molds = $this->frparam('molds',1);
		if($molds==''){
			Error(JZLANG('模块为空，请选择模块！'));
		}
		$this->molds = M('Molds')->find(array('biaoshi'=>$molds));
		$data = $this->frparam();
		$res = molds_search($molds,$data);
		$this->isshow = $this->frparam('isshow');
		$this->tid = $this->frparam('tid');
		$this->fields_search = $res['fields_search'];
		$this->fields_list = M('Fields')->findAll(array('molds'=>$molds,'islist'=>1),'listorders desc,id asc');
		$this->classtypes = $this->classtypetree;
		if($this->frparam('ajax')){
			
			$sql = '1=1';
			if($this->admin['classcontrol']==1 && $this->admin['isadmin']!=1 && $this->molds['isclasstype']==1 && $this->molds['iscontrol']!=0){
				$a1 = explode(',',$this->tids);
				$a2 = array_filter($a1);
				$tids = implode(',',$a2);
				$sql.=' and tid in('.$tids.') ';
			}
			$web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
			$allowclass = M('classtype')->findAll(['lang'=>$web]);
			$allow_tids = [0];
			foreach($allowclass as $v){
				$allow_tids[]=$v['id'];
			}
			$sql .= " and tid in (".implode(',',$allow_tids).") ";
			$get_sql = ($res['fields_search_check']!='') ? (' and '.$res['fields_search_check']) : '';
			$sql .= $get_sql;
			
			
			$page = new Page($molds);
			$data = $page->where($sql)->orderby('orders desc,id desc')->limit($this->frparam('limit',0,10))->page($this->frparam('page',0,1))->go();
			$ajaxdata = [];
			foreach($data as $k=>$v){
				if(isset($classtypedata[$v['tid']])){
					$v['new_tid'] = $v['tid']!=0 ? $classtypedata[$v['tid']]['classname'] : '-';
				}else{
					$v['new_tid'] = '[未分类]';
				}
				
				if($molds=='tags'){
					$v['view_url'] = get_domain().'/tags/index/id/'.$v['id'];
				}else{
					$v['view_url'] = gourl($v,$v['htmlurl']);
				}
				
				$v['edit_url'] = U('Extmolds/editmolds',array('id'=>$v['id'],'molds'=>$molds));
				
				foreach($this->fields_list as $vv){
					$v[$vv['field']] = format_fields($vv,$v[$vv['field']]);
				}
				$ajaxdata[]=$v;
				
			}
			
			$pages = $page->pageList();
			$this->pages = $pages;
			$this->lists = $data;
			$this->sum = $page->sum;
			JsonReturn(['code'=>0,'data'=>$ajaxdata,'count'=>$page->sum]);
			
			
		}
		
		
		if(file_exists(APP_PATH.APP_HOME.'/'.HOME_VIEW.'/'.Tpl_template.'/'.$molds.'-list.html')){
			$this->display($molds.'-list');
		}else{
			$this->display('extmolds-list');
		}
		exit;
		
		
	}
	//栏目模块
	public function indexclass(){
	 
		$web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
		$this->lang = $web;
		$classtype = M('classtype')->findAll(['lang'=>$web],'orders desc');
		$classtype = set_class_haschild($classtype);
		$classtype = getTree($classtype);
		$this->classtypes = $classtype;
		//$this->classtypes = $this->classtypetree;
		//模块
		$molds = M('Molds')->findAll(['isopen'=>1]);
		$fs = array();
		foreach($molds as $v){
			$fs[$v['biaoshi']] = $v;
		}
		$this->molds = M('molds')->find(['biaoshi'=>'classtype']);
		$this->moldslist = $fs;
		$this->display('classtype-list');
		exit;
	}
	
	public function addclass(){
		$this->fields_biaoshi = 'classtype';
		
		if($this->frparam('go')==1){

			$htmlurl = $this->frparam('htmlurl',1);
			if($htmlurl==''){
				$htmlurl = str_replace(' ','',pinyin($this->frparam('classname',1)));
			}
			$langs = M('lang')->findAll();
			$islang = [];
			foreach($langs as $v){
				$islang[$v['lang']] = $v['id'];
			}
			if(isset($islang[$htmlurl])){
				JsonReturn(array('status'=>0,'info'=>JZLANG('栏目链接设置错误！不能设置语言区域标识！')));
			}
			$web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
			if($this->webconf['islevelurl'] && $this->frparam('pid')!=0){
				//层级
				$classtypetree = classTypeData();
				$htmlurl = $classtypetree[$this->frparam('pid')]['htmlurl'].'/'.$htmlurl;
			}else{
				
				if($web!=APP_LANG){
					$htmlurl = $web.'/'.$htmlurl;
				}
			}
			if(in_array(strtolower($htmlurl),array('message','user','comment','home','common','order','tags','wechat','login'))){
				JsonReturn(array('status'=>0,'info'=>JZLANG('URL链接命名不能是').'：message,user,comment,home,common,order,tags,wechat,login,jzpay'));
			}
			if(stripos($htmlurl,'.php')!==false){
				JsonReturn(array('status'=>0,'info'=>JZLANG('非法URL')));
			}
			$w['lang'] = $web;
			$w['pid'] = $this->frparam('pid');
			$w['orders'] = $this->frparam('orders');
			$w['classname'] = $this->frparam('classname',1);
			$w['seo_classname'] = $this->frparam('seo_classname',1) ? $this->frparam('seo_classname',1) : $this->frparam('classname',1);
			$w['molds'] = $this->frparam('molds',1);
			$w['description'] = $this->frparam('description',1);
			$w['keywords'] = $this->frparam('keywords',1);
			$w['litpic'] = $this->frparam('litpic',1);
			$w['body'] = $this->frparam('body',4);
			$w['htmlurl'] = $htmlurl;
			$w['iscover'] = $this->frparam('iscover');
			$w['lists_html'] = $this->frparam('lists_html',1);
			$w['details_html'] = $this->frparam('details_html',1);
			$w['gourl'] = $this->frparam('gourl',1);
			$w['lists_num'] = $this->frparam('lists_num');
			$w['gids'] = implode(',',$this->frparam('gids',2));
			
			if($w['pid']){
				$parent = M('classtype')->find(array('id'=>$w['pid']));
				if($parent['iscover']==1){
					$w['lists_html']= $w['lists_html'] ?: ($this->frparam('lists_html_write',1) ? $this->frparam('lists_html_write',1) : $parent['lists_html']);
					$w['details_html']= $w['details_html'] ?: ($this->frparam('details_html_write',1) ? $this->frparam('details_html_write',1) : $parent['details_html']);
					$w['lists_num']=$parent['lists_num'];
				}else{
					$w['lists_html']= $w['lists_html'] ?: $this->frparam('lists_html_write',1);
					$w['details_html']= $w['details_html'] ?: $this->frparam('details_html_write',1);
				}
			}else{
				$w['lists_html']= $w['lists_html'] ?: $this->frparam('lists_html_write',1);
				$w['details_html']= $w['details_html'] ?: $this->frparam('details_html_write',1);
			}
			
			//$w['lists_html'] = str_ireplace('.html','',$w['lists_html']);
			//$w['details_html'] = str_ireplace('.html','',$w['details_html']);
			
			
			$data = $this->frparam();
			$data = get_fields_data($data,'classtype');
			$w = array_merge($data,$w);
            $w['addtime'] = $w['updatetime'] = time();
			$a = M('classtype')->add($w);
			if($a){
				if($w['pid']){
                    $sql = " tids like '%,".$w['pid'].",%' or (molds='".$w['molds']."' and (tids is null or tids='')) ";
                }else{
                    $sql = "molds='".$w['molds']."'";
                }
                $fields=M('fields')->findAll($sql);
				foreach ($fields as $v){
					if($v['tids']){
						M('fields')->update(array('id'=>$v['id']),array('tids'=>$v['tids'].$a.','));
					}else{
						M('fields')->update(array('id'=>$v['id']),array('tids'=>','.$a.','));
					}
					
				}
				//这里
				setCache('classtypetree',null);
				setCache('classtype',null);
				setCache('mobileclasstype',null);
				setCache('classtypedatamobile',null);
				setCache('classtypedatapc',null);
				JsonReturn(array('status'=>1,'info'=>JZLANG('添加栏目成功，继续添加~'),'url'=>U('addclass',array('pid'=>$w['pid'],'biaoshi'=>$w['molds']))));
			}else{
				JsonReturn(array('status'=>0,'info'=>JZLANG('新增失败！')));
			}
		}
		//模块
		$this->molds = M('Molds')->findAll(['isopen'=>1]);
		
		$this->pid = $this->frparam('pid');
		$this->biaoshi = $this->frparam('biaoshi',1);
        $web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
        $newclass = [];
        foreach($this->classtypetree as $v){
            if($v['lang']==$web){
                $newclass[]=$v;
            }
        }
        
        
        $this->classtypes = $newclass;
		$this->display('classtype-add');
		exit;
	}
	
	public function editclass(){
		$this->data = M('classtype')->find(array('id'=>$this->frparam('id')));
		$this->fields_biaoshi = 'classtype';
		if($this->frparam('go')==1){
			$htmlurl = $this->frparam('htmlurl',1);
			if($htmlurl==''){
				$htmlurl = str_replace(' ','',pinyin($this->frparam('classname',1)));
			}
			$langs = M('lang')->findAll();
			$islang = [];
			foreach($langs as $v){
				$islang[$v['lang']] = $v['id'];
			}
			if(isset($islang[$htmlurl])){
				JsonReturn(array('status'=>0,'info'=>JZLANG('栏目链接设置错误！不能设置语言区域标识！')));
			}
			if(in_array(strtolower($htmlurl),array('message','user','comment','home','common','order','tags','wechat','login'))){
				JsonReturn(array('status'=>0,'info'=>JZLANG('URL链接命名不能是').'：message,user,comment,home,common,order,tags,wechat,login,jzpay'));
			}
			if(stripos($htmlurl,'.php')!==false){
				JsonReturn(array('status'=>0,'info'=>'非法URL'));
			}
			$w['pid'] = $this->frparam('pid');
			$w['orders'] = $this->frparam('orders');
			$w['classname'] = $this->frparam('classname',1);
			$w['molds'] = $this->frparam('molds',1);
			if(!M('molds')->find(['biaoshi'=>$w['molds']])){
				JsonReturn(array('status'=>1,'info'=>JZLANG('模型错误！')));
			}
			$web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
			$w['lang'] = $web;
			$w['description'] = $this->frparam('description',1);
			$w['keywords'] = $this->frparam('keywords',1);
			$w['id'] = $this->frparam('id');
			$w['litpic'] = $this->frparam('litpic',1);
			$w['body'] = $this->frparam('body',4);
			$w['htmlurl'] = $htmlurl;
			$w['iscover'] = $this->frparam('iscover');
			$w['lists_html'] = $this->frparam('lists_html',1) ? $this->frparam('lists_html',1) : $this->frparam('lists_html_write',1);
			$w['details_html'] = $this->frparam('details_html',1) ? $this->frparam('details_html',1) : $this->frparam('details_html_write',1);
			$w['lists_num'] = $this->frparam('lists_num');
			$w['gourl'] = $this->frparam('gourl',1);
			//$w['lists_html'] = str_ireplace('.html','',$w['lists_html']);
			//$w['details_html'] = str_ireplace('.html','',$w['details_html']);
			$w['gids'] = $this->frparam('gids',2) ? implode(',',$this->frparam('gids',2)) : '';
			$data = $this->frparam();
			$data = get_fields_data($data,'classtype');
			$w = array_merge($data,$w);
			
			
			//检测pid是否为该栏目下级
			if(checkClass($w['pid'],$this->data['id']) || ($w['pid']==$this->data['id'])){
				JsonReturn(array('status'=>0,'info'=>JZLANG('不能选择当前栏目及下级为顶级栏目')));
			}

            $w['updatetime'] = time();
			$a = M('classtype')->update(array('id'=>$w['id']),$w);
			if($a){
				if($w['iscover']==1){
					$children = M('classtype')->update(array('pid'=>$w['id']),array('lists_html'=>$w['lists_html'],'details_html'=>$w['details_html'],'lists_num'=>$w['lists_num']));
				}
				//批量修改栏目对应的模块内容htmlurl
				if($this->data['htmlurl']!=$data['htmlurl']){
					M($data['molds'])->update(array('tid'=>$data['id']),array('htmlurl'=>$data['htmlurl']));
			
				}
				//批量修改栏目url
				if($this->webconf['islevelurl']==1){
					if( ($this->data['htmlurl']!=$data['htmlurl']) || ($this->data['pid']!=$w['pid'])){
						
						//层级
						$classtypetree = classTypeData();
						$children = get_children($classtypetree[$w['id']],$classtypetree,5);
						//计算当前url
						//以前的url替换成当前的url
						$old_htmlurl = $this->data['htmlurl'];
						if(strpos($w['htmlurl'],'/')!==false){
							//获取最后一个
							$htl = explode('/',$w['htmlurl']);
							$htl_new = end($htl);//最后一个名字
							
						}else{
							$htl_new = $w['htmlurl'];
						}
						
						if($w['pid']!=0){
							$p_html = $classtypetree[$w['pid']]['htmlurl'];
							$new_htmlurl = $p_html.'/'.$htl_new;
						}else{
							
							$new_htmlurl = $htl_new;
							//顶级则需要加上语言区域标识
							
							if($web!=APP_LANG){
								$new_htmlurl = $web.'/'.$new_htmlurl;
							}
						}
						//更新栏目及其内容HTML
						M('classtype')->update(['id'=>$data['id']],['htmlurl'=>$new_htmlurl]);
						M($data['molds'])->update(array('tid'=>$data['id']),array('htmlurl'=>$new_htmlurl));
						
						foreach($children as $v){
							$html = substr($v['htmlurl'],strlen($old_htmlurl));
							$htmlurl_s = $new_htmlurl.$html;
							M('classtype')->update(['id'=>$v['id']],['htmlurl'=>$htmlurl_s]);
							M($v['molds'])->update(['tid'=>$v['id']],['htmlurl'=>$htmlurl_s]);
						}

					}


				}
				
				setCache('classtypetree',null);
				setCache('classtype',null);
				setCache('mobileclasstype',null);
				setCache('classtypedatamobile',null);
				setCache('classtypedatapc',null);
				JsonReturn(array('status'=>1));
			}else{
				JsonReturn(array('status'=>0,'info'=>JZLANG('您未做任何修改，不能提交！')));
			}
		}
		
		//模块
		$this->molds = M('Molds')->findAll(['isopen'=>1]);
        $web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
        $newclass = [];
        foreach($this->classtypetree as $v){
            if($v['lang']==$web){
                $newclass[]=$v;
            }
        }
        
        
        $this->classtypes = $newclass;
		$this->display('classtype-edit');
		exit;
	}
	
    public function addmany(){
        if($_POST){
            $type = $this->frparam('type',0,1);
            if($type==1){
                $molds = $this->frparam('molds',1);
                $pid = $this->frparam('pid',0,0);
                $classname = $this->frparam('classname',1);
                if(!trim($classname)){
                    JsonReturn(['code'=>1,'msg'=>'栏目不能为空！']);
                }
                $classname = explode("\n",trim($classname));
                $classtypetree = classTypeData();
                foreach($classname as $k=>$v){
                    if($v){
                        if(strpos($v,'|')!==false){
                            $d = explode('|',$v);
                        }else{
                            $d = [$v,pinyin($v,'first')];
                        }
                        $w['molds'] = $molds;
                        $w['classname'] = $d[0];
                        $w['seo_classname'] = $d[0];
                        $w['pid'] = $pid;
                        $d[1] = str_replace(' ','-',$d[1]);
                        
                        //顶级则需要加上语言区域标识
                        $web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
                        if($this->webconf['islevelurl'] && $w['pid']!=0){
                            //层级
                            $html = $classtypetree[$w['pid']]['htmlurl'].'/'.$d[1];
                        }else{
                            $html = $d[1];
                            
                            if($web!=APP_LANG){
                                $html = $web.'/'.$html;
                            }
                        }
                        if(stripos($html,'.php')!==false){
                            JsonReturn(array('code'=>1,'info'=>'非法URL'));
                        }
                        
                        $w['htmlurl'] = str_replace(' ','-',$html);
                        $w['lists_num'] = $this->frparam('lists_num',0,10);
                        $w['lists_html'] = $this->frparam('lists_html',1);
                        $w['details_html'] = $this->frparam('details_html',1);
                        $w['isshow'] =$this->frparam('isshow',0,1);
                        $w['ishome'] =$this->frparam('ishome',0,1);
                        $w['addtime'] = $w['updatetime'] = time();
                        $r = M('classtype')->add($w);
                        $sql = "molds='".$w['molds']."'";
                        $fields=M('fields')->findAll($sql);
                        foreach ($fields as $s){
                            if($s['tids']){
                                M('fields')->update(array('id'=>$s['id']),array('tids'=>$s['tids'].$r.','));
                            }else{
                                M('fields')->update(array('id'=>$s['id']),array('tids'=>','.$r.','));
                            }
                            
                        }
                        $w = [];
                    }
                    
                    
                }
            }else{
                
                $data_0 = $this->frparam('data_0',2);
                $data_1 = $this->frparam('data_1',2);
                $data_2 = $this->frparam('data_2',2);
                $data_3 = $this->frparam('data_3',2);
                $data_4 = $this->frparam('data_4',2);
                $data_5 = $this->frparam('data_5',2);
                $data_6 = $this->frparam('data_6',2);
                $data_7 = $this->frparam('data_7',2);
                $data_8 = $this->frparam('data_8',2);
                $classtypetree = classTypeData();
                foreach($data_1 as $k=>$v){
                    if($v && $v!=''){
                        
                        $w['molds'] = $data_0[$k];
                        $w['classname'] = $v;
                        $w['pid'] = $data_2[$k];
                        $data_3[$k] = $data_3[$k] ? : pinyin($data_3[$k],'first');
                        
                        //顶级则需要加上语言区域标识
                        $web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
                        if($this->webconf['islevelurl'] && $w['pid']!=0){
                            //层级
                            $html = $classtypetree[$w['pid']]['htmlurl'].'/'.$data_3[$k];
                        }else{
                            $html = $data_3[$k];
                            
                            if($web!=APP_LANG){
                                $html = $web.'/'.$html;
                            }
                        }
                        if(stripos($html,'.php')!==false){
                            JsonReturn(array('code'=>1,'info'=>'非法URL'));
                        }
                        
                        
                        
                        $w['htmlurl'] = $html;
                        $w['lists_num'] = $data_4[$k];
                        $w['lists_html'] = $data_5[$k];
                        $w['details_html'] = $data_6[$k];
                        $w['isshow'] = $data_7[$k];
                        $w['orders'] = $data_8[$k];
                        $w['addtime'] = $w['updatetime'] = time();
                        $r = M('classtype')->add($w);
                        
                        $sql = "molds='".$w['molds']."'";
                        $fields=M('fields')->findAll($sql);
                        foreach ($fields as $s){
                            if($s['tids']){
                                M('fields')->update(array('id'=>$s['id']),array('tids'=>$s['tids'].$r.','));
                            }else{
                                M('fields')->update(array('id'=>$s['id']),array('tids'=>','.$r.','));
                            }
                            
                        }
                        
                        $w = [];
                    }
                    
                    
                }
                
            }
            
            setCache('classtypetree',null);
            setCache('classtype',null);
            setCache('mobileclasstype',null);
            setCache('classtypedatamobile',null);
            setCache('classtypedatapc',null);
            JsonReturn(['code'=>0,'msg'=>'success']);
        }
        $this->molds = M('molds')->find(['biaoshi'=>'classtype']);
        $web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
        $this->moldslist = M('molds')->findAll(['isopen'=>1]);
        $classtype = M('classtype')->findAll(['isclose'=>0,'lang'=>$web],'orders desc');
        $classtype = set_class_haschild($classtype);
        $classtypetree = getTree($classtype);
        $this->classtypes = $classtypetree;
        
        $this->display('classtype-addmany');
        exit;
        
    }
	
	public function changeClass(){
		$pid = $this->frparam('pid',0,0);
		$tids = $this->frparam('tids',1);
		$tids_arr = explode(',',$tids);
		
		foreach($tids_arr as $v){
			//检测pid是否为该栏目下级
			if(checkClass($pid,$v) || ($pid==$v)){
				JsonReturn(array('code'=>1,'msg'=>JZLANG('不能选择当前栏目及下级为顶级栏目')));
			}
		}
		
		//批量修改栏目url
		if($this->webconf['islevelurl']==1){
				//层级
				$classtypetree = classTypeData();
			foreach($tids_arr as $v){	
				$children = get_children($classtypetree[$v],$classtypetree,5);
				//计算当前url
				//以前的url替换成当前的url
				$old_htmlurl = $classtypetree[$v]['htmlurl'];
				if(strpos($old_htmlurl,'/')!==false){
					//获取最后一个
					$htl = explode('/',$old_htmlurl);
					$htl_new = end($htl);//最后一个名字
					
				}else{
					$htl_new = $old_htmlurl;
				}
				
				if($pid!=0){
					$p_html = $classtypetree[$pid]['htmlurl'];
					$new_htmlurl = $p_html.'/'.$htl_new;
				}else{
					$new_htmlurl = $htl_new;
					//顶级则需要加上语言区域标识
					$web = isset($_SESSION['web']) ? $_SESSION['web'] : APP_LANG;
					if($web!=APP_LANG){
						$new_htmlurl = $web.'/'.$new_htmlurl;
					}
				}
				//更新栏目及其内容HTML
				M('classtype')->update(['id'=>$v],['htmlurl'=>$new_htmlurl,'pid'=>$pid]);
				M($classtypetree[$v]['molds'])->update(array('tid'=>$v),array('htmlurl'=>$new_htmlurl,'tid'=>$pid));
				
				foreach($children as $vv){
					$html = substr($vv['htmlurl'],strlen($old_htmlurl));
					$htmlurl_s = $new_htmlurl.$html;
					M('classtype')->update(['id'=>$vv['id']],['htmlurl'=>$htmlurl_s]);
					M($vv['molds'])->update(['tid'=>$vv['id']],['htmlurl'=>$htmlurl_s]);
				}

			}


		}else{
			M('classtype')->update(' id in('.$tids.')',['pid'=>$pid]);
			
		}
		setCache('classtypetree',null);
		setCache('classtype',null);
		setCache('mobileclasstype',null);
		setCache('classtypedatamobile',null);
		setCache('classtypedatapc',null);
		JsonReturn(array('code'=>0,'msg'=>JZLANG('操作成功！')));
		exit;
		
		
	}

    function addFields(){

        if($this->frparam('go',1)==1){

            $data['field'] = strtolower($this->frparam('field',1));
            $data['molds'] = strtolower($this->frparam('molds',1));
            $data['fieldname'] = $this->frparam('fieldname',1);
            $data['tips'] = $this->frparam('tips',1);
            $data['fieldtype'] = $this->frparam('fieldtype');
            $data['tids'] = $this->frparam('tids',1);
            $data['fieldlong'] = $this->frparam('fieldlong',1);
            $data['body'] = $this->frparam('body',1);
            $data['orders'] = $this->frparam('orders');
            $data['ismust'] = $this->frparam('ismust');
            $data['isshow'] = $this->frparam('isshow');
            $data['ishome'] = $this->frparam('ishome');
            $data['isadmin'] = $this->frparam('isadmin');
            $data['issearch'] = $this->frparam('issearch');
            $data['islist'] = $this->frparam('islist');
            $data['format'] = $this->frparam('format',1);
            $data['vdata'] = $this->frparam('vdata',1);
            $data['isajax'] = $this->frparam('isajax');
            $data['listorders'] = $this->frparam('listorders');
            $data['isext'] = $this->frparam('isext');
            if($data['fieldname']=='' || $data['field']==''){
                JsonReturn(array('code'=>1,'msg'=>'字段名和字段标识不能为空！'));
            }

            //检测是否存在该模块
            if(M('Fields')->find(array('field'=>$data['field'],'molds'=>$data['molds']))){
                JsonReturn(array('code'=>1,'msg'=>'字段标识已存在！'));
            }
            //取消保护字段，可以继续创建
            if(in_array($data['field'],['sql','jzcache','jzcachetime','table','orderby','limit','ispage','notin','in','empty','notempty','fields','like','day','as','file'])){
                JsonReturn(array('code'=>1,'msg'=>'系统保护字段，不允许创建！'));
            }
            // $sql = "select count(*) as n from information_schema.columns where table_name = '".DB_PREFIX.$data['molds']."' and TABLE_SCHEMA='".DB_PREFIX.$data['molds']."' and column_name = '".$data['field']."'";
            // $check = M()->findSql($sql);
            // if($check[0]['n']){
            // JsonReturn(array('code'=>1,'msg'=>'字段标识已存在！'));
            // }

            $sql = 'SHOW COLUMNS FROM '.DB_PREFIX.$data['molds'];
            $list = M()->findSql($sql);
            $isgo = true;
            //不管存不存在，都可以创建
            foreach($list as $v){
                if($v['Field']==$data['field']){
                    $isgo = false;
                    //JsonReturn(array('code'=>1,'msg'=>'字段标识已存在！'));
                }
            }


            $data['tids'] = ($data['tids']!='')?(','.$data['tids'].','):$data['tids'];
            $sql = "ALTER TABLE ".DB_PREFIX.$data['molds']." ADD ".$data['field']." ";
            $data['fieldlong'] = $this->frparam('fieldlong_'.$data['fieldtype'],1);
            switch($data['fieldtype']){
                case 1:
                case 2:
                case 18:
                case 19:
                    $sql .= "VARCHAR(".$data['fieldlong'].") CHARACTER SET utf8 default ";
                    if($data['vdata'] || $data['vdata']==0){
                        $sql .=  "'".$data['vdata']."'";
                    }else{
                        $sql .= ' NULL ';
                    }
                    break;
                case 3:
                case 15:
                case 6:
                case 10:
                    $sql .= "TEXT CHARACTER SET utf8 default ";
                    $sql .= ' NULL ';

                    break;
                case 4:
                case 17:
                    if($data['fieldlong']>11 || $data['fieldlong']<=0){
                        JsonReturn(array('code'=>1,'msg'=>'字段长度不对！'));
                    }
                    $sql .= "INT(".$data['fieldlong'].") DEFAULT ";
                    if($data['vdata']){
                        $sql .=  "'".$data['vdata']."'";
                    }else{
                        $sql .= " '0' NOT NULL ";
                    }
                    break;
                case 11:
                    if($data['fieldlong']!=11){
                        JsonReturn(array('code'=>1,'msg'=>'字段长度不对,时间属性必须长度为11'));
                    }
                    $sql .= "INT(".$data['fieldlong'].") DEFAULT ";
                    if($data['vdata']){
                        $sql .=  "'".$data['vdata']."'";
                    }else{
                        $sql .= " '0' NOT NULL ";
                    }
                    break;
                case 5:
                case 9:
                    $sql .= "VARCHAR(".$data['fieldlong'].") CHARACTER SET utf8 default ";
                    if($data['vdata'] || $data['vdata']==0){
                        $sql .=  "'".$data['vdata']."'";
                    }else{
                        $sql .= " NULL ";
                    }
                    break;

                case 7:
                case 8:
                case 12:
                    $data['body'] = $this->frparam('body_'.$data['fieldtype'],1);
                    $sql .= "VARCHAR(".$data['fieldlong'].") CHARACTER SET utf8 default ";
                    if($data['vdata'] || $data['vdata']==0){
                        $sql .= "'".$data['vdata']."'";
                    }else{
                        $sql .= " NULL ";
                    }
                    break;
                case 13:
                    if($data['fieldlong']>11 || $data['fieldlong']<=0){
                        JsonReturn(array('code'=>1,'msg'=>'字段长度不对！'));
                    }
                    $sql .= "INT(".$data['fieldlong'].") DEFAULT ";
                    if($data['vdata']){
                        $sql .=  "'".$data['vdata']."'";
                    }else{
                        $sql .= " '0' NOT NULL ";
                    }
                    $data['body'] = $this->frparam('molds_select',1).','.$this->frparam('molds_list_field',1);
                    break;
                case 14:
                    if(strpos($data['fieldlong'],',')===false){
                        JsonReturn(array('code'=>1,'msg'=>'字段长度不对,decimal字段长度格式[ 整数位数,小数位数 ]'));
                    }
                    $sql .= "DECIMAL(".$data['fieldlong'].") DEFAULT ";
                    if($data['vdata']){
                        $sql .=  "'".$data['vdata']."'";
                    }else{
                        $sql .= " '".$this->frparam('body_14',1)."' NOT NULL ";
                    }
                    break;
                case 16:
                    $sql .= "VARCHAR(".$data['fieldlong'].") DEFAULT ";
                    if($data['vdata'] || $data['vdata']==0){
                        $sql .=  "'".$data['vdata']."'";
                    }else{
                        $sql .= " NULL ";
                    }
                    $data['body'] = $this->frparam('molds_select_muti',1).','.$this->frparam('molds_list_field_muti',1);
                    break;
                case 20:
                    $sql .= "VARCHAR(".$data['fieldlong'].") DEFAULT ";
                    if($data['vdata'] || $data['vdata']==0){
                        $sql .=  "'".$data['vdata']."'";
                    }else{
                        $sql .= " NULL ";
                    }
                    $data['body'] = $this->frparam('molds_select_tid_muti',1).','.$this->frparam('molds_list_field_tid_muti',1);
                    break;
                case 21:
                    if($data['fieldlong']>11 || $data['fieldlong']<=0){
                        JsonReturn(array('code'=>1,'msg'=>JZLANG('字段长度不对！')));
                    }
                    $sql .= "INT(".$data['fieldlong'].") DEFAULT ";
                    if($data['vdata']){
                        $sql .=  "'".$data['vdata']."'";
                    }else{
                        $sql .= " '0' NOT NULL ";
                    }
                    $data['body'] = $this->frparam('molds_select_tid',1).','.$this->frparam('molds_list_field_tid',1);
                    break;

            }
            //由于已经存在，所以不需要再执行一遍SQL
            if($isgo){
                $x = M()->runSql($sql);
            }


            $n = M('Fields')->add($data);
            if(!$n){
                //新增字段记录失败，删除新增字段--不需要删除
                //$delsql = "ALTER TABLE ".DB_PREFIX.$data['molds']." DROP COLUMN ".$data['field'];
                //M()->runSql($delsql);
                JsonReturn(array('code'=>1,'msg'=>'字段创建成功，但是字段表记录失败，请反馈官方解决！'));
            }
            JsonReturn(array('code'=>0,'msg'=>'字段创建成功！'));


        }
        $this->classtypes = get_classtype_tree();
        $this->molds = $this->frparam('molds',1);
        $this->display('fields-add');
        exit;
    }

    function editFields(){

        if($this->frparam('go',1)==1){

            if($this->frparam('id')){
                $data['field'] = strtolower($this->frparam('field',1));
                $data['molds'] = strtolower($this->frparam('molds',1));
                $data['fieldname'] = $this->frparam('fieldname',1);
                $data['tips'] = $this->frparam('tips',1);
                $data['fieldtype'] = $this->frparam('fieldtype');
                $data['tids'] = $this->frparam('tids',1);
                $data['fieldlong'] = $this->frparam('fieldlong',1);
                $data['body'] = $this->frparam('body',1);
                $data['orders'] = $this->frparam('orders');
                $data['ismust'] = $this->frparam('ismust');
                $data['isshow'] = $this->frparam('isshow');
                $data['ishome'] = $this->frparam('ishome');
                $data['isadmin'] = $this->frparam('isadmin');
                $data['issearch'] = $this->frparam('issearch');
                $data['islist'] = $this->frparam('islist');
                $data['format'] = $this->frparam('format',1);
                $data['vdata'] = $this->frparam('vdata',1);
                $data['isajax'] = $this->frparam('isajax');
                $data['listorders'] = $this->frparam('listorders');
                $data['isext'] = $this->frparam('isext');
                if($data['fieldname']=='' || $data['field']==''){
                    JsonReturn(array('code'=>1,'msg'=>'字段名和字段标识不能为空！'));
                }

                $data['tids'] = ($data['tids']!='')?(','.$data['tids'].','):$data['tids'];
                $old = M('Fields')->find(array('id'=>$this->frparam('id')));
                $data['fieldlong'] = $this->frparam('fieldlong_'.$data['fieldtype'],1);
                //只是更改样式，不更改字段属性
                if($old['field']==$data['field']){

                    //判断长度是否不同
                    if($data['fieldlong']!=$old['fieldlong'] || $data['vdata']!=$old['vdata']){
                        $sql =  "ALTER TABLE ".DB_PREFIX.$old['molds']." modify column ".$old['field']."  ";
                        switch($data['fieldtype']){
                            case 1:
                            case 2:
                            case 5:
                            case 7:
                            case 8:
                            case 9:
                            case 12:
                            case 16:
                            case 18:
                            case 19:
                            case 20:
                                $sql.=" varchar(".$data['fieldlong'].") default";
                                if($data['vdata'] || $data['vdata']==0){
                                    $sql .=  "'".$data['vdata']."'";
                                }else{
                                    $sql .= ' NULL ';
                                }
                                break;
                            case 3:
                            case 15:
                            case 6:
                            case 10:
                                $sql .= "TEXT CHARACTER SET utf8 default ";
                                $sql .= ' NULL ';
                                break;
                            case 4:
                            case 11:
                            case 13:
                            case 17:
                            case 21:
                                $sql.=" int(".$data['fieldlong'].") default ";
                                if($data['vdata']){
                                    $sql .=  "'".$data['vdata']."'";
                                }else{
                                    $sql .= ' 0 ';
                                }
                                break;
                            case 14:
                                $sql.=" decimal(".$data['fieldlong'].") default ";
                                if($data['vdata']){
                                    $sql .=  "'".$data['vdata']."'";
                                }else{
                                    $sql .= " '".$this->frparam('body_14',1)."' NOT NULL ";
                                }
                                break;

                        }
                        $x = M()->runSql($sql);

                    }
                    if($data['fieldtype']==7 || $data['fieldtype']==8 || $data['fieldtype']==12 || $data['fieldtype']==14){
                        $data['body'] = $this->frparam('body_'.$data['fieldtype'],1);
                    }
                    if($data['fieldtype']==13){
                        $data['body'] = $this->frparam('molds_select',1).','.$this->frparam('molds_list_field',1);
                    }
                    if($data['fieldtype']==16){
                        $data['body'] = $this->frparam('molds_select_muti',1).','.$this->frparam('molds_list_field_muti',1);
                    }
                    if($data['fieldtype']==20){
                        $data['body'] = $this->frparam('molds_select_tid_muti',1).','.$this->frparam('molds_list_field_tid_muti',1);
                    }
                    if($data['fieldtype']==21){
                        $data['body'] = $this->frparam('molds_select_tid',1).','.$this->frparam('molds_list_field_tid',1);
                    }
                    if(M('Fields')->update(array('id'=>$this->frparam('id')),$data)){
                        JsonReturn(array('code'=>0,'msg'=>'字段修改成功！'));
                    }else{
                        JsonReturn(array('code'=>1,'msg'=>'字段修改失败！'));
                    }

                }else{
                    if(in_array($data['field'],['id','sql','jzcache','jzcachetime','table','orderby','limit','ispage','notin','in','empty','notempty','fields','like','tids','day','as','istop','istuijian','ishot','isall','file'])){
                        JsonReturn(array('code'=>1,'msg'=>'系统保护字段，不允许创建！'));
                    }
                }

                $sql = "ALTER TABLE ".DB_PREFIX.$old['molds']." change ".$old['field']." ".$data['field']." ";

                switch($data['fieldtype']){
                    case 1:
                    case 2:
                    case 5:
                    case 9:
                    case 18:
                    case 19:

                        $sql .= "VARCHAR(".$data['fieldlong'].") CHARACTER SET utf8 default ";
                        if($data['vdata'] || $data['vdata']==0){
                            $sql .=  "'".$data['vdata']."'";
                        }else{
                            $sql .= ' NULL ';
                        }
                        break;
                    case 3:
                    case 15:
                    case 6:
                    case 10:
                        $sql .= "TEXT CHARACTER SET utf8 default ";
                        $sql .= ' NULL ';

                        break;
                    case 4:
                    case 17:
                        if($data['fieldlong']>11 || $data['fieldlong']<=0){
                            JsonReturn(array('code'=>1,'msg'=>'字段长度不对！'));
                        }
                        $sql .= "INT(".$data['fieldlong'].") DEFAULT ";
                        if($data['vdata']){
                            $sql .=  "'".$data['vdata']."'";
                        }else{
                            $sql .= " '0' NOT NULL ";
                        }
                        break;
                    case 11:
                        if($data['fieldlong']!=11){
                            JsonReturn(array('code'=>1,'msg'=>'字段长度不对,时间属性必须长度为11'));
                        }
                        $sql .= "INT(".$data['fieldlong'].") DEFAULT ";
                        if($data['vdata']){
                            $sql .=  "'".$data['vdata']."'";
                        }else{
                            $sql .= " '0' NOT NULL ";
                        }
                        break;
                    case 14:
                        if(strpos($data['fieldlong'],',')===false){
                            JsonReturn(array('code'=>1,'msg'=>'字段长度不对,decimal字段长度格式[ 整数位数,小数位数 ]'));
                        }
                        $sql .= "DECIMAL(".$data['fieldlong'].") DEFAULT ";
                        if($data['vdata']){
                            $sql .=  "'".$data['vdata']."'";
                        }else{
                            $sql .= " '".$this->frparam('body_14',1)."' NOT NULL ";
                        }
                        break;


                    case 7:
                    case 8:
                    case 12:
                        $sql .= "VARCHAR(".$data['fieldlong'].") CHARACTER SET utf8 default ";
                        if($data['vdata'] || $data['vdata']==0){
                            $sql .=  "'".$data['vdata']."'";
                        }else{
                            $sql .= ' NULL ';
                        }
                        $data['body'] = $this->frparam('body_'.$data['fieldtype'],1);
                        break;
                    case 13:
                        if($data['fieldlong']>11 || $data['fieldlong']<=0){

                            JsonReturn(array('code'=>1,'msg'=>'字段长度不对！'));
                        }
                        $sql .= "INT(".$data['fieldlong'].") DEFAULT ";
                        if($data['vdata']){
                            $sql .=  "'".$data['vdata']."'";
                        }else{
                            $sql .= " '0' NOT NULL ";
                        }
                        $data['body'] = $this->frparam('molds_select',1).','.$this->frparam('molds_list_field',1);
                        break;
                    case 16:
                        if($data['fieldlong']>11 || $data['fieldlong']<=0){

                            JsonReturn(array('code'=>1,'msg'=>JZLANG('字段长度不对！')));
                        }
                        $sql .= "VARCHAR(".$data['fieldlong'].") CHARACTER SET utf8 default ";
                        if($data['vdata'] || $data['vdata']==0){
                            $sql .=  "'".$data['vdata']."'";
                        }else{
                            $sql .= ' NULL ';
                        }
                        $data['body'] = $this->frparam('molds_select_muti',1).','.$this->frparam('molds_list_field_muti',1);
                        break;
                    case 21:
                        if($data['fieldlong']>11 || $data['fieldlong']<=0){

                            JsonReturn(array('code'=>1,'msg'=>JZLANG('字段长度不对！')));
                        }
                        $sql .= "INT(".$data['fieldlong'].") DEFAULT ";
                        if($data['vdata']){
                            $sql .=  "'".$data['vdata']."'";
                        }else{
                            $sql .= " '0' NOT NULL ";
                        }
                        $data['body'] = $this->frparam('molds_select_tid',1).','.$this->frparam('molds_list_field_tid',1);
                        break;
                    case 20:
                        if($data['fieldlong']>11 || $data['fieldlong']<=0){

                            JsonReturn(array('code'=>1,'msg'=>JZLANG('字段长度不对！')));
                        }
                        $sql .= "VARCHAR(".$data['fieldlong'].") CHARACTER SET utf8 default ";
                        if($data['vdata'] || $data['vdata']==0){
                            $sql .=  "'".$data['vdata']."'";
                        }else{
                            $sql .= ' NULL ';
                        }
                        $data['body'] = $this->frparam('molds_select_tid_muti',1).','.$this->frparam('molds_list_field_tid_muti',1);
                        break;
                }
                $x = M()->runSql($sql);

                if(M('Fields')->update(array('id'=>$this->frparam('id')),$data)){
                    JsonReturn(array('code'=>0,'msg'=>'字段修改成功！'));
                    exit;
                }else{
                    JsonReturn(array('code'=>1,'msg'=>'字段修改失败！'));
                    exit;
                }
            }



        }
        if($this->frparam('id')){
            $this->data = M('Fields')->find(array('id'=>$this->frparam('id')));
        }

        $this->classtypes = get_classtype_tree();
        $this->display('fields-edit');
        exit;
    }
	

}