<?php

use OSS\OssClient;
use OSS\Core\OssException;

class Aliyun {
	
	public $accessKeyId;
	public $accessKeySecret;
	
	public function save($filepath,$config){
		
		require_once __DIR__ . '/aliyunoss/autoload.php';
		
		
		// 从环境变量中获取访问凭证。运行本代码示例之前，请确保已设置环境变量OSS_ACCESS_KEY_ID和OSS_ACCESS_KEY_SECRET。
		$accessKeyId = $config['upload']['aliyun']["id"];
		$accessKeySecret = $config['upload']['aliyun']["key"];
		// Endpoint以杭州为例，其它Region请按实际情况填写。
		$endpoint = $config['upload']['aliyun']["endpoint"];
		// 填写Bucket名称，例如examplebucket。
		$bucket= $config['upload']['aliyun']['bucket'];
		// <yourObjectName>表示上传文件到OSS时需要指定包含文件后缀，不包含Bucket名称在内的完整路径，例如abc/efg/123.jpg。
		$pic = explode('.',$filepath);
		$object = date('Y').'/'.date('m').'/'.date('d').'/'.date('YmdHis').rand(1000,9999).'.'.end($pic);
		$content = file_get_contents(APP_PATH.$filepath);

		try {
			$ossClient = new OssClient($accessKeyId, $accessKeySecret, $endpoint);
			$ossClient->putObject($bucket, $object, $content);
			return $config['upload']['aliyun']['web'].'/'.$object;
			
		} catch (OssException $e) {
			print $e->getMessage();
			exit;
		}
				
		
		
		
	}
	
}
