<?php

// +----------------------------------------------------------------------
// | JiZhiCMS { 极致CMS，给您极致的建站体验 }  
// +----------------------------------------------------------------------
// | Copyright (c) 2018-2099 http://www.jizhicms.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 留恋风 <2581047041@qq.com>
// +----------------------------------------------------------------------
// | Date：2019/10/08
// +----------------------------------------------------------------------


namespace app\home\plugins;

use app\home\c\CommonController;
use frphp\lib\Controller;
use frphp\extend\Page;

class GetDataController extends CommonController
{
	function _init(){
	    header('Access-Control-Allow-Origin:*');
		parent::_init();
		$apidata = M('plugins')->find(['filepath'=>'apidata','isopen'=>1]);
		if(!$apidata){
			JsonReturn(['code'=>1,'msg'=>'插件未开启！']);
		}
		$this->config = json_decode($apidata['config'],1);
		
		$this->checkIp();
		$this->checkKey();
	}
	
	//获取数据处理
	/**
	
		model: 模块名，必填
		key:访问秘钥，必填
		where:查询条件，默认查询该模块所有内容，根据请求，自动获取
		orders:查询排序，默认id倒序，字符串格式： 'addtime desc' ，可以不填
		limit:显示条数，默认查询所有，数字，正整数，可以不填
		fields:获取字段，默认查询所有，字符串格式： 'id,classname,tid' ，可以不填
	
	**/
	function index(){
		
		$tables = explode(',',$this->config['tables']);
		$table = $this->frparam('model',1,false);
		if($table && is_array($tables) && in_array($table,$tables)){
			$model = $this->frparam('model',1,false);
			
			$orders = $this->frparam('orders',1,' id desc ');
			$limit = $this->frparam('limit',0,NULL);
			$fields = $this->frparam('fields',1,null);
			$page = $this->frparam('page',0,1);
			if(!$model){
				JsonReturn(['code'=>1,'msg'=>'model参数错误！']);
			}
			if($page>1){
			    $limit = ($page-1)*$limit.','.$limit;
			}
			if($model=='sysconfig'){
				$limit = null;
			}
			
			$data = $this->frparam();
			unset($data['model']);
			unset($data['orders']);
			unset($data['limit']);
			unset($data['fields']);
			unset($data['key']);
			$where = null;
			foreach($data as $k=>$v){
				$where[$k] = $this->frparam($k,1);
			}
            $where['addtime'] = ['<=',time()];
			$res = M($model)->findAll($where,$orders,$fields,$limit);
			JsonReturn(['code'=>0,'data'=>$res]);
			
		}else{
			JsonReturn(['code'=>1,'msg'=>'数据不存在！']);
		}
		
	}

    function getclass(){

        $tables = explode(',',$this->config['tables']);
        $table = $this->frparam('model',1,false);
        if($table && is_array($tables) && in_array($table,$tables)){
            $data = $this->frparam();
            $orders = $this->frparam('orders',1,' orders desc ');
            $limit = $this->frparam('limit',0,NULL);
            $fields = $this->frparam('fields',1,null);
            $page = $this->frparam('page',0,1);
            if(!$table){
                JsonReturn(['code'=>1,'msg'=>'model参数错误！']);
            }
            if($page>1){
                $limit = ($page-1)*$limit.','.$limit;
            }


            $sql = '';
            if($this->frparam('id') && $this->frparam('isall')){
                $sql = '  id in ('.implode(',',$this->classtypedata[$this->frparam('id')]['children']['ids']).') ';
            }else if($this->frparam('id')){
                $sql = 'id='.$this->frparam('id');
            }
            if($sql){
                $res = M('classtype')->findAll($sql,$orders,$fields,$limit);
            }else{
                $res = [];
            }



            JsonReturn(['code'=>0,'data'=>$res]);

        }else{
            JsonReturn(['code'=>1,'msg'=>'数据不存在！']);
        }

    }

    function hits(){
        $tables = explode(',',$this->config['tables']);
        $table = $this->frparam('model',1,false);
        if($table && is_array($tables) && in_array($table,$tables)){
            $model = $this->frparam('model',1,false);
            $id = $this->frparam('id');
            if(!$model){
                JsonReturn(['code'=>1,'msg'=>'model参数错误！']);
            }
            if(!$id){
                JsonReturn(['code'=>1,'msg'=>'缺少ID参数！']);
            }
            M($model)->goInc(['id'=>$id],'hits');
            JsonReturn(['code'=>0,'msg'=>'success','data'=>M($model)->getField(['id'=>$id],'hits')]);
        }else{
            JsonReturn(['code'=>1,'msg'=>'数据不存在！']);
        }
    }

    function getDataPage(){
	    $tables = explode(',',$this->config['tables']);
		$table = $this->frparam('model',1,false);
		if($table && is_array($tables) && in_array($table,$tables)){
			$model = $this->frparam('model',1,false);
			
			$orders = $this->frparam('orders',1,' id desc ');
			$limit = $this->frparam('limit',0,10);
			$fields = $this->frparam('fields',1,null);
			$page = $this->frparam('page',0,1);
			if(!$model){
				JsonReturn(['code'=>1,'msg'=>'model参数错误！']);
			}
			
			$data = $this->frparam();
			unset($data['model']);
			unset($data['orders']);
			unset($data['limit']);
			unset($data['fields']);
			unset($data['key']);
		
			$classtypedata = classTypeData();
    		foreach($classtypedata as $k=>$v){
    			$classtypedata[$k]['children'] = get_children($v,$classtypedata);
    		}
			$sql = ' isshow=1 ';
		    if($this->frparam('tid')){
		        $sql .= ' and tid in ('.implode(',',$classtypedata[$this->frparam('tid')]['children']['ids']).') and addtime<='.time();
		    }else{
		        $sql = null;
    			foreach($data as $k=>$v){
    				$sql[$k] = $this->frparam($k,1);
    			}
                $sql['addtime'] = ['<=',time()];
		    }
		
			$obj = new Page($model);
			$res = $obj->where($sql)->orderby($orders)->limit($limit)->page($page)->go();
            $sum = $obj->sum;//总数据
            $listpage = $obj->listpage;//分页数组-自定义分页可用
            $prevpage = $obj->prevpage;//上一页
            $nextpage = $obj->nextpage;//下一页
            $allpage = $obj->allpage;//总页数
            JsonReturn(['code'=>0,'data'=>$res,'sum'=>$sum,'listpage'=>$listpage,'prevpage'=>$prevpage,'nextpage'=>$nextpage,'allpage'=>$allpage]);
			
		}else{
			JsonReturn(['code'=>1,'msg'=>'数据不存在！']);
		}
	}
	
	function getDataSearch(){
	    $tables = explode(',',$this->config['tables']);
		$table = $this->frparam('model',1,false);
		if($table && is_array($tables) && in_array($table,$tables)){
			$model = $this->frparam('model',1,false);
			
			$orders = $this->frparam('orders',1,' id desc ');
			$limit = $this->frparam('limit',0,10);
			$fields = $this->frparam('fields',1,null);
			$page = $this->frparam('page',0,1);
			if(!$model){
				JsonReturn(['code'=>1,'msg'=>'model参数错误！']);
			}
			
			$data = $this->frparam();
			unset($data['model']);
			unset($data['orders']);
			unset($data['limit']);
			unset($data['fields']);
			unset($data['key']);
		
			$classtypedata = classTypeData();
    		foreach($classtypedata as $k=>$v){
    			$classtypedata[$k]['children'] = get_children($v,$classtypedata);
    		}
			$sql = ' isshow=1 and addtime<='.time();
			
			$search = $this->frparam('search',1);
			$word = $this->frparam('word',1);
			if($search && $word){
			    $s = explode(',',$search);
			    $sql.= ' and (';
			    $sqx = [];
			    foreach ($s as $v){
			        $sqlx[] =" ".$v." like '%".$word."%' ";
			    }
			    $sql.= implode(' or ',$sqlx);
			    $sql.=' ) ';
			}
			
			
		    if($this->frparam('tid')){
		        $sql .= ' and tid in ('.implode(',',$classtypedata[$this->frparam('tid')]['children']['ids']).') ';
		    }
		
			$obj = new Page($model);
			$res = $obj->where($sql)->orderby($orders)->limit($limit)->page($page)->go();
            $sum = $obj->sum;//总数据
            $listpage = $obj->listpage;//分页数组-自定义分页可用
            $prevpage = $obj->prevpage;//上一页
            $nextpage = $obj->nextpage;//下一页
            $allpage = $obj->allpage;//总页数
            JsonReturn(['code'=>0,'data'=>$res,'sum'=>$sum,'listpage'=>$listpage,'prevpage'=>$prevpage,'nextpage'=>$nextpage,'allpage'=>$allpage]);
			
		}else{
			JsonReturn(['code'=>1,'msg'=>'数据不存在！']);
		}
	}
	
	//新增/修改
    function savedata(){
        if(!$this->config['isaddedit'] && $this->config['isaddedit']!=1){
            JsonReturn(['code'=>1,'msg'=>'未开启新增修改权限！']);
        }
        $tables = explode(',',$this->config['tables']);
        $table = strtolower($this->frparam('model',1,false));
        if($table && is_array($tables) && in_array($table,$tables)){
            $id = $this->frparam('id',0);
            $w = [];

            if($id){

                $w = $this->frparam();
                foreach ($w as $k=>$v){
                    if($k=='body'){
                        $w[$k] = $this->frparam($k,4);
                    }else{
                        $w[$k] = $this->frparam($k,1);
                    }

                }


                $r = M($table)->update(['id'=>$id],$w);
            }else{
                switch($table){
                    case 'article':
                        $w = $this->frparam();
                        $w['title'] = $this->frparam('title',1);
                        $w['seo_title'] = $this->frparam('seo_title',1) ? $this->frparam('seo_title',1) : $w['title'];
                        $w['description'] = $this->frparam('description',1,'');
                        $w['keywords'] = $this->frparam('keywords',1,'');
                        $w['body'] = $this->frparam('body',4);
                        $w['tid'] = $this->frparam('tid',0,0);

                        $w = $this->get_fields_data($w,'article');

                        break;
                    case 'product':
                        $w = $this->frparam();
                        $w['title'] = $this->frparam('title',1);
                        $w['seo_title'] = $this->frparam('seo_title',1) ? $this->frparam('seo_title',1) : $w['title'];
                        $w['description'] = $this->frparam('description',1,'');
                        $w['keywords'] = $this->frparam('keywords',1,'');
                        $w['body'] = $this->frparam('body',4);
                        $w['price'] = $this->frparam('price',3,0);
                        $w['stock_num'] = $this->frparam('stock_num',0,20);
                        $w['tid'] = $this->frparam('tid',0,0);

                        $w = $this->get_fields_data($w,'product');




                        break;
                    default:

                        $w = $this->frparam();
                        $w = $this->get_fields_data($w,$table);

                        break;
                }

                //处理自定义URL
                if($w['ownurl']){
                    if(M('customurl')->find(['url'=>$w['ownurl']])){
                        JsonReturn(array('code'=>1,'msg'=>'已存在相同的自定义URL！'));
                    }

                }
                if($w['tags']){
                    $w['tags'] = ','.$w['tags'].',';
                }

                if(!$w['description']){
                    $w['description'] = ($this->frparam('description',1,'')=='') ? newstr(strip_tags($w['body']),200) : $this->frparam('description',1);
                    if(!$w['litpic']){
                        $pattern='/<img.+src=\"?(.+\.(jpg|gif|bmp|bnp|PNG))\"?.+>/i';
                        if($this->frparam('body',1,'')!=''){
                            preg_match_all($pattern,stripslashes($w['body']),$matchContent);

                            if(isset($matchContent[1][0])){
                                $w['litpic'] = $matchContent[1][0];
                            }else{
                                $w['litpic'] = '';
                            }
                        }else{
                            $w['litpic'] = '';
                        }

                    }
                }
                if($w['litpic'] && $this->config['islocal']==1){
                    $w['litpic'] = stripos($w['litpic'],'http')!==false ? $this->localimg($w['litpic'],$w['tid'],$table) : $w['litpic'];
                }
                $w['molds'] = $table;
                if($w['tid']){
                    $w['htmlurl'] = $this->classtypedata[$w['tid']]['htmlurl'] ?? '';
                }
                $r = M($table)->add($w);
            }

            if($r){

                if($w['ownurl']){
                    M('customurl')->add(['molds'=>$table,'url'=>$w['ownurl'],'tid'=>$w['tid'],'addtime'=>time(),'aid'=>$r]);
                }

                //tags处理
                if($w['tags']){
                    $tags = explode(',',$w['tags']);
                    foreach($tags as $v){
                        if($v!=''){
                            $tagData = M('tags')->find(['keywords'=>$v]);
                            if(!$tagData){
                                $ww['keywords'] = $v;
                                $ww['newname'] = '';
                                $ww['url'] = '';
                                $ww['num'] = -1;
                                $ww['isshow'] = 1;
                                $ww['number'] = 1;
                                $ww['tids'] = $w['tid'] ? ','.$w['tid'].',' : '';
                                $ww['target'] = '_blank';
                                M('tags')->add($ww);

                            }else{
                                $tags_tids = $tagData['tids'] ? $tagData['tids'].$w['tid'].',' : ','.$w['tid'].',';
                                $ww['tids'] = $tags_tids;
                                $ww['number'] = $tagData['number']+1;
                                M('tags')->update(['keywords'=>$v],$ww);
                            }
                            $ww = [];
                        }
                    }
                }


                JsonReturn(['code'=>0,'msg'=>'操作成功！']);
            }else{
                JsonReturn(['code'=>1,'msg'=>'操作失败！']);
            }


        }else{
            JsonReturn(['code'=>1,'msg'=>'模块参数错误，操作失败！']);
        }
    }

    function message(){
        if(!isset($this->config['ismessage']) || $this->config['ismessage']!=1){
            JsonReturn(['code'=>1,'msg'=>'请先在API数据插件开启留言']);
        }
        if($_POST){

            $w = $this->frparam();
            $w = $this->get_fields_data($w,'message',0);

            $w['body'] = $this->frparam('body',1,'','POST');
            $w['user'] = $this->frparam('user',1,'','POST');
            $w['tel'] = $this->frparam('tel',1,'','POST');
            $w['aid'] = $this->frparam('aid',0,0,'POST');
            $w['tid'] = $this->frparam('tid',0,0,'POST');
            $w['email'] = $this->frparam('email',1,'','POST');
            $w['orders'] = 0;
            $w['istop'] = 0;
            $w['hits'] = 0;

            if($this->webconf['autocheckmessage']==1){
                $w['isshow'] = 1;
            }else{
                $w['isshow'] = 0;
            }




            $w['ip'] = GetIP();
            $w['addtime'] = time();
            if(isset($_SESSION['member'])){
                $w['userid'] = $_SESSION['member']['id'];
            }else{
                $w['userid'] = 0;
            }

            if($this->frparam('title',1,'','POST')==''){
                JsonReturn(['code'=>1,'msg'=>JZLANG('标题不能为空！')]);
            }
            if($w['user']==''){
                JsonReturn(['code'=>1,'msg'=>'称呼不能为空！']);
            }


            $w['title'] = $this->frparam('title',1);
            //仅在存在手机号的情况进行检测手机号是否有效-可自由设置
            if($w['tel']){
                if(!preg_match("/^(13[0-9]|14[579]|15[0-3,5-9]|16[6]|17[0135678]|18[0-9]|19[89])\\d{8}$/",$w['tel'])){
                    //$this->error('您的手机号格式不正确！');
                    JsonReturn(['code'=>1,'msg'=>JZLANG('您的手机号格式不正确！')]);
                }

            }
            // 不为空检测
            $sql = " molds='message' and isshow=1 ";
            $fields_list = M('Fields')->findAll($sql,'orders desc,id asc');
            if($fields_list){
                foreach($fields_list as $v){
                    if($v['ismust']==1){
                        if($w[$v['field']]==''){
                            if(in_array($v['fieldtype'],array(6,10))){
                                if($w[$v['field'].'_urls']==''){

                                    JsonReturn(['code'=>1,'msg'=>$v['fieldname'].JZLANG('不能为空！')]);
                                }
                            }else{
                                JsonReturn(['code'=>1,'msg'=>$v['fieldname'].JZLANG('不能为空！')]);
                            }

                        }
                    }
                }
            }




            if(!isset($_SESSION['message_time'])){
                $_SESSION['message_time'] = time();
                $_SESSION['message_num'] = 0;
            }

            if(($_SESSION['message_time']+10*60)<time()){
                $_SESSION['message_num'] = 0;
                $_SESSION['message_time'] = time();
            }
            $_SESSION['message_num']++;
            if($_SESSION['message_num']>5 && ($_SESSION['message_time']+10*60)>=time()){
                JsonReturn(['code'=>0,'msg'=>JZLANG('您操作过于频繁，请10分钟后再尝试！')]);
            }


            $res = M('message')->add($w);
            if($res){
                JsonReturn(['code'=>0,'msg'=>JZLANG('提交成功！我们会尽快回复您！'),'url'=>get_domain()]);
            }else{
                JsonReturn(['code'=>1,'msg'=>JZLANG('提交失败，请重试！')]);
            }



        }



    }
    function localimg($value,$tid=0,$molds=''){
        $webconfig = webConf();
        $web_basehost    = get_domain();
        if(isset($webconfig['admin_save_path'])){
            //替换日期事件
            $t = time();
            $d = explode('-', date("Y-y-m-d-H-i-s"));
            $format = $webconfig['admin_save_path'];
            $format = str_replace("{yyyy}", $d[0], $format);
            $format = str_replace("{yy}", $d[1], $format);
            $format = str_replace("{mm}", $d[2], $format);
            $format = str_replace("{dd}", $d[3], $format);
            $format = str_replace("{hh}", $d[4], $format);
            $format = str_replace("{ii}", $d[5], $format);
            $format = str_replace("{ss}", $d[6], $format);
            $format = str_replace("{time}", $t, $format);
            if($format!=''){
                //检查文件是否存在
                if(strpos($format,'/')!==false && !file_exists(APP_PATH.$format)){
                    $path = explode('/',$format);
                    $path1 = APP_PATH;
                    foreach($path as $v){
                        if($path1==APP_PATH){
                            if(!file_exists($path1.$v)){
                                mkdir($path1.$v,0777);
                            }
                            $path1.=$v;
                        }else{
                            if(!file_exists($path1.'/'.$v)){
                                mkdir($path1.'/'.$v,0777);
                            }
                            $path1.='/'.$v;
                        }
                    }
                }else if(!file_exists(APP_PATH.$format)){
                    mkdir(APP_PATH.$format,0777);
                }
                $admin_save_path = $format;

            }else{
                $admin_save_path = 'public/Admin';
            }


        }else{
            $admin_save_path = 'public/Admin';
        }
        $dirname =  $admin_save_path.'/';
        $imgUrl = trim($value);
        //  $imgUrl = preg_replace('/\\\"/', '', $imgUrl); //img 被转义的数据
        $imgUrl = preg_replace('/#/', '', $imgUrl);

        // 本站图片 / 根网址图片 / 第三方存储插件的图片
        if (preg_match("/\/\/('.$web_basehost.')\//i", $imgUrl)) {
            return $value;
        }
        // 不是合法链接
        if (!preg_match("#^http(s?):\/\/#i", $imgUrl)) {
            return $value;
        }

        $heads = @get_headers($imgUrl, 1);

        // 获取请求头并检测死链
        if (empty($heads)) {
            return $value;
        } else if (!(stristr($heads[0], "200") && !stristr($heads[0], "304"))) {
            return $value;
        }
        // 图片扩展名
        $fileType = substr($heads['Content-Type'], -4, 4);
        if (!preg_match("#\.(jpg|jpeg|gif|png|ico|bmp|webp|svg)#i", $fileType)) {
            if ($fileType == 'image/gif') {
                $pix = "gif";
            } else if ($fileType == 'image/png') {
                $pix = "png";
            } else if ($fileType == 'image/x-icon') {
                $pix = "ico";
            } else if ($fileType == 'image/bmp') {
                $pix = "bmp";
            }  else if ($fileType == 'image/webp') {
                $pix = "webp";
            } else if ($heads['Content-Type'] == 'image/svg+xml') {
                $pix = "svg";
            } else {
                $pix = 'jpg';
            }
        }
        $pix = strtolower($pix);

        //打开输出缓冲区并获取远程图片
        ob_start();
        $context = stream_context_create(
            array('http' => array(
                'follow_location' => false // don't follow redirects
            ))
        );
        readfile($imgUrl, false, $context);
        $img = ob_get_contents();
        ob_end_clean();
        preg_match("/[\/]([^\/]*)[\.]?[^\.\/]*$/", $imgUrl, $m);

        $file             = [];
        $file['oriName']  = $m ? $m[1] : "";
        $file['filesize'] = strlen($img);
        $file['ext']      = $pix;
        $file['name']     = date("ymdHis") . mt_rand(100, 999) .'.'. $file['ext'];
        $file['fullName'] = $dirname . $file['name'];
        $fullName         = $file['fullName'];

        //检查文件大小是否超出限制
        if ($file['filesize'] >= 20480000) {
            return $value;
        }

        //移动文件
        if (!(file_put_contents($fullName, $img) && file_exists($fullName))) { //移动失败
            return $value;
        }
        //处理水印
        if( (strtolower($pix)=='png' || strtolower($pix)=='jpg' || strtolower($pix)=='jpeg') && $webconfig['iswatermark']==1 ){
            watermark($file['fullName'],APP_PATH.$webconfig['watermark_file'],$webconfig['watermark_t'],$webconfig['watermark_tm'],$webconfig['text_word']);
        }


        $fileurl = '/'.$file['fullName'];
        $filesize = round(filesize(APP_PATH.$file['fullName'])/1024,2);
        M('pictures')->add(['litpic'=>'/'.$file['fullName'],'addtime'=>time(),'userid'=>$_SESSION['admin']['id'],'size'=>$filesize,'filetype'=>strtolower($pix),'tid'=>$tid,'molds'=>$molds]);
        return $fileurl;

    }


    function get_fields_data($data, $molds, $isadmin = 1)
    {
        if ($isadmin) {
            $fields = M('fields')->findAll(['molds' => $molds, 'isadmin' => 1], 'orders desc,id asc');
        } else {
            //前台需要判断是否前台显示
            $fields = M('fields')->findAll(['molds' => $molds, 'isshow' => 1, 'ishome' => 1], 'orders desc,id asc');
        }
        $newdata = [];
        foreach ($fields as $v) {
            if (array_key_exists($v['field'], $data)) {
                switch ($v['fieldtype']) {
                    case 1:
                    case 2:
                    case 5:
                    case 7:
                    case 9:
                    case 12:
                    case 18:
                    case 21:
                        $data[$v['field']] = format_param($data[$v['field']], 1);
                        break;
                    case 11:
                        $data[$v['field']] = strtotime(format_param($data[$v['field']], 1));
                        break;
                    case 3:
                        $text = $data[$v['field']];
                        if($this->config['islocal']==1){
                            $text = remote_data_local($text, $data['tid'], $data['molds']);
                        }

                        $data[$v['field']] = format_param($text, 6);

                        break;
                    case 4:
                    case 13:
                    case 17:
                        $data[$v['field']] = format_param($data[$v['field']]);
                        break;
                    case 14:
                        $data[$v['field']] = format_param($data[$v['field']], 3);
                        break;
                    case 8:
                        $r = implode(',', format_param($data[$v['field']], 2));
                        if ($r) {
                            $r = ',' . $r . ',';
                        }
                        $data[$v['field']] = $r;
                        break;
                    case 16:
                    case 20:
                        if(is_array($data[$v['field']])){
                            $data[$v['field']] = $data[$v['field']] ? ',' . implode(',',format_param($data[$v['field']], 2)) . ',' : '';
                        }else{
                            $data[$v['field']] = $data[$v['field']] ? ',' . format_param($data[$v['field']], 1) . ',' : '';
                        }
                        break;
                    case 15:
                        $r = implode('||', format_param($data[$v['field']], 2));
                        $data[$v['field']] = $r;
                        break;
                    case 19:
                        $data[$v['field']] = format_param($data[$v['field']], 1);
                        $data[$v['field']] = $data[$v['field']] ? ',' . $data[$v['field']] . ',' : '';
                        break;

                }
                $newdata[$v['field']] = $data[$v['field']];
            } else if (array_key_exists($v['field'] . '_urls', $data)) {
                switch ($v['fieldtype']) {
                    case 6:
                    case 10:
                        if (array_key_exists($v['field'] . '_des', $data)) {
                            $pics = format_param($data[$v['field'] . '_urls'], 2);
                            $pics_des = format_param($data[$v['field'] . '_des'], 2);
                            foreach ($pics as $k => $vv) {
                                if ($pics_des[$k]) {
                                    $pics[$k] = $vv . '|' . $pics_des[$k];
                                }
                            }
                            $data[$v['field']] = implode('||', $pics);

                        } else {
                            $data[$v['field']] = implode('||', format_param($data[$v['field'] . '_urls'], 2));
                        }

                        break;
                }
                $newdata[$v['field']] = $data[$v['field']];
            } else {
                $data[$v['field']] = '';

            }
            if (isset($data['id'])) {
                $data['id'] = format_param($data['id']);
            }

        }

        if ($isadmin) {
            return $data;
        } else {
            //前台只返回允许的字段
            return $newdata;
        }


    }

    //IP审核
	function checkIp(){
		$ip = GetIP();//获取IP
		if($this->config['ischeckip']==1){
			$iplist = explode('||',$this->config['iplist']);
			if(!is_array($iplist) || !in_array($ip,$iplist)){
				JsonReturn(['code'=>1,'msg'=>'IP不在白名单！']);
			}
		}
		
	}
	//秘钥审核
	function checkKey(){
		$key = $this->config['key'];
		$current_key = $this->frparam('key',1);
		if($key!=$current_key){
			JsonReturn(['code'=>1,'msg'=>'秘钥错误！']);
		}
	}
	
	
}